/*If necessary, change the path to match the location of the course data*/
LIBNAME ORION 's:\workshop';

TITLE1 "Sales Summary for Recent Orders";
FOOTNOTE;

PROC TABULATE DATA=ORION.ORDER_ANALYSIS;
	VAR Total_Retail_Price;
	CLASS Order_Type /	ORDER=UNFORMATTED MISSING;
	CLASS Country /	ORDER=UNFORMATTED MISSING;
	TABLE /* Row Dimension */
			Country={LABEL=' '} 
			ALL={LABEL='Total'},
		  /* Column Dimension */
			Order_Type*
			  Total_Retail_Price={LABEL=' '}*{STYLE={BACKGROUND=#00CCFF}}*
		      Sum={LABEL=' '}*FORMAT=DOLLAR10.
			ALL={LABEL='Total Sales'}*
			  Total_Retail_Price={LABEL=' '}*
			    Sum={LABEL=' '}*FORMAT=DOLLAR10.
			ALL={LABEL='Total Items'}*
			  Total_Retail_Price={LABEL=' '}*
			    N={LABEL=' ' }
			/ misstext=' '
;
RUN; 

TITLE; FOOTNOTE;

