/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jdbctest;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author hallgato
 */
public class JDBCTest {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        try {
            DriverManager.registerDriver(new org.apache.derby.jdbc.ClientDriver());
        } catch (SQLException ex) {
            Logger.getLogger(JDBCTest.class.getName()).log(Level.SEVERE, null, ex);
        }

        Connection conn;
        Statement stmt;
        PreparedStatement pstmt;
        ResultSet rs;

        try {
            conn = DriverManager.getConnection("jdbc:derby://localhost:1527/sample", "app", "app");
            stmt = conn.createStatement();

            try {
                stmt.executeUpdate("CREATE TABLE STUDENT (neptun VARCHAR(6), name VARCHAR(100), credits INTEGER)");
            } catch (SQLException ex) {
                if (ex.getErrorCode()==30000) {
                    System.out.println("A tábla már létezik...");
                    stmt.executeUpdate("DROP TABLE STUDENT");
                    stmt.executeUpdate("CREATE TABLE STUDENT (neptun VARCHAR(6), name VARCHAR(100), credits INTEGER)");
                }
            }

            pstmt = conn.prepareStatement("INSERT INTO STUDENT (neptun, name, credits) VALUES (?,?,?)");
            pstmt.setString(1, "OIU345");
            pstmt.setString(2, "Pál");
            pstmt.setInt(3, 35);
            pstmt.executeUpdate();
            
            pstmt.setString(1, "zht453");
            pstmt.setString(2, "Péter");
            pstmt.setInt(3, 30);
            pstmt.executeUpdate();
            
            pstmt.setString(1, "sdf432");
            pstmt.setString(2, "Ágnes");
            pstmt.setInt(3, 31);
            pstmt.executeUpdate();
            
            System.out.println("------------------------------");
            rs = stmt.executeQuery("SELECT * FROM STUDENT");
            while (rs.next()){
                System.out.println(rs.getString(2) + " " + rs.getInt(3));
            }                         
            
            stmt.executeUpdate("DELETE FROM STUDENT WHERE (name='Pál')");
            
            System.out.println("------------------------------");
            rs = stmt.executeQuery("SELECT * FROM STUDENT");
            while (rs.next()){
                System.out.println(rs.getString(2) + " " + rs.getInt(3));
            }                         
            
            pstmt.close();
            stmt.close();
            conn.close();
        } catch (SQLException ex) {
            System.out.println("Ez lesz a már létező tábla hibalkódja: " + ex.getErrorCode());
            Logger.getLogger(JDBCTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

}
