/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hibernatetest.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

/**
 *
 * @author admin
 */
@Entity
@Table(name = "ANIMAL")
public class Animal {

    public static enum Gender {
        MALE, FEMALE
    }

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "animal_id", unique = true, nullable = false)
    private int id;

    @Override
    public String toString() {
        return "Animal{" + "gender=" + gender + ", age=" + age + ", name=" + name + '}';
    }
    
    @Column(name = "animal_gender", unique = true, nullable = false)
    private Gender gender;
    
    @Column(name = "animal_age", unique = true, nullable = false)
    private int age;
    
    @Column(name = "animal_name", unique = true, nullable = false)
    private String name;
    
    @ManyToOne
    @Cascade(CascadeType.ALL)
    @JoinColumn(name = "zoo_id")
    private Zoo owner_zoo;

    public Zoo getOwner_zoo() {
        return owner_zoo;
    }

    public void setOwner_zoo(Zoo owner_zoo) {
        this.owner_zoo = owner_zoo;
    }
    
    
    public Animal() {
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
