/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package hibernatetest.db;

import hibernatetest.model.Animal;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

/**
 *
 * @author admin
 */
public class AnimalDAO implements AutoCloseable {

    private final Session session;

    public AnimalDAO() {
        session = HibernateUtil.getSessionFactory().openSession();
    }

    public void addAnimal(Animal a) {
        session.beginTransaction();
        session.save(a);
        session.getTransaction().commit();
    }

    public void deleteAnimal(Animal a) {
        session.beginTransaction();
        session.delete(a);
        session.getTransaction().commit();
    }

    public void updateAnimal(Animal a) {
        session.beginTransaction();
        session.update(a);
        session.getTransaction().commit();
    }
    
    public List<Animal> getAnimals(){
        String hql = "FROM hibernatetest.model.Animal";
	Query query = session.createQuery(hql);
	return query.list();
    }

    @Override
    public void close(){
        session.close();
        HibernateUtil.closeSessionFactory();
    }

}
