package L6_JUnit.tests;
/**
 * These samples are simplified versions of the project available on the class 
 * "Kompetens szoftvertesztelés a gyakorlatban" https://w1.inf.unideb.hu/dtk/costip (in hungarian)
 */
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.util.Arrays;
import java.util.Collection;

import static org.junit.Assert.*;

@RunWith(Parameterized.class)
public class Test008Parameters {
    @Parameterized.Parameters
    public static Collection data() {
        return Arrays.asList(new Integer[][]{
                {0, 0, 0},
                {1, 1, 0},
                {2, 1, 1},
                {3, 2, 2}, //wrong input data
                {4, 3, 1},
                {5, 5, 0},
                {6, 8, -2}
        });
    }
    
    int expected;
    int input1;
    int input2;
    
    public Test008Parameters(int expected, int input1, int input2) {
        this.expected = expected;
        this.input1 = input1;
        this.input2 = input2;
    }

    @Test
    /**
     * Test the adition with the above data.
     */
    public void testAddition() {
        assertEquals(expected, add(input1, input2));
    }
    private int add(int m, int n) {
        return m + n;
    }
}
