package L6_JUnit.tests;
/**
 * These samples are simplified versions of the project available on the class 
 * "Kompetens szoftvertesztelés a gyakorlatban" https://w1.inf.unideb.hu/dtk/costip (in hungarian)
 */
import L6_JUnit.model.PersonBuilder;
import org.junit.*;

public class Test004LifeCycle {
    private static PersonBuilder pb;
    
    @BeforeClass //in JUnit 5 replaced by BeforeAll
    public static void beforeTestClass() {
        System.out.println("Runs ones before test all tests in class");
        pb = new PersonBuilder();
    }
    
    @Before //in JUnit 5 replaced by BeforeEach
    public void beforeAllTests() {
        System.out.println("Runs before each test");
        if(pb==null) Assert.fail(
                "The service become unavailable before the test");
    }
    
    @Test
    public void testMe() {
        System.out.println("testMe");
        pb.getPerson(10);
        //pb=null; //Why is this statement wrong???
    }
    
    @Test
    public void testMeToo() {
        System.out.println("testMeToo");
        pb.getPerson(11);
    }
    
    @After //in JUnit 5 replaced by AfterEach
    public void afterAllTests() {
        System.out.println("Runs after each test");
        if(pb==null) Assert.fail(
                "The service become unavailable after the test");
    }
    
    @AfterClass //in JUnit 5 replaced by AfterAll
    public static void afterTestClass() {
        System.out.println("Runs ones after test all tests in class");
        pb = null;
    }
}
