package L6_JUnit.tests;
/**
 * These samples are simplified versions of the project available on the class 
 * "Kompetens szoftvertesztelés a gyakorlatban" https://w1.inf.unideb.hu/dtk/costip (in hungarian)
 */
import L6_JUnit.model.Person;
import L6_JUnit.model.PersonBuilder;
import org.junit.Test;
import static org.junit.Assert.*;

public class Test003Asserts {

    PersonBuilder pb = new PersonBuilder();

    @Test
    /**
     * If the ID exists the method must not return null
     * Make this test work
     */
    public void testNotNullAssert() {
        Person p = pb.getPerson(10);
    }

    @Test
    /**
     * If the ID does not exist, return null
     * Make this test work
     */
    public void testNullAssert() {
        Person p = pb.getPerson(-10);
    }

    @Test
    /**
     * Make this test work only by changing
     * one assignment
     */
    public void testSameAssert() {

        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();

        assertSame(obj1,obj2);

        assertNotSame(obj1,obj3);
    }

    @Test
    /**
     * Make this test automatically fail
     */
    public void testFail() {
        
    }

}

