package L6_JUnit.tests;
/**
 * These samples are simplified versions of the project available on the class 
 * "Kompetens szoftvertesztelés a gyakorlatban" https://w1.inf.unideb.hu/dtk/costip (in hungarian)
 */
import L6_JUnit.model.Person;
import L6_JUnit.model.PersonBuilder;
import org.hamcrest.CoreMatchers;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import org.hamcrest.core.IsNull;
import org.junit.Test;

import static org.junit.Assert.*;

public class Test002More {

    PersonBuilder pb = new PersonBuilder();
    @Test
    /**
     * The PersonBuilder.getPerson method
     * returns the object with a given known and existing ID
     */
    public void testFindByIdExists() {
        int testId = 10;
        Person p = pb.getPerson(testId);
        assertNotNull(p);
        assertEquals(p.getId(), testId);
        
        //Hamcrest matchers
        //assertThat(p, not(nullValue()));
        //assertThat(p.getId(), is(testId));
    }
    
    @Test
     /**
     * The PersonBuilder.getPerson method
     * returns null for non existing IDs
     */
    public void testFindByIdNotExists() {
        Person p = pb.getPerson(-10);
        assertNull(p);
        //assertThat(p, is(nullValue()));
        
        p = pb.getPerson(101);
        assertNull(p);
        //assertThat(p, is(nullValue()));
    }
}
