create table app_user (
    id bigint not null auto_increment,
    email varchar(255),
    first_name varchar(255),
    last_name varchar(255),
    password varchar(255),
    primary key (id)
);

create table role (
    id bigint not null auto_increment,
    description varchar(255),
    role_name varchar(255),
    primary key (id)
);

INSERT INTO role (ROLE_NAME, DESCRIPTION) VALUES ('GENERAL_USER', 'General role for every user.');
INSERT INTO role (ROLE_NAME, DESCRIPTION) VALUES ('ADMIN', 'Admin role.');

create table uploaded_graph (
    id bigint not null auto_increment,
    file_name varchar(255) not null,
    upload_date datetime not null,
    user_id bigint not null,
    primary key (id)
);

create table graph_analysis_result (
    id bigint not null auto_increment,
    algorithm_type varchar(255) not null,
    user_graph_id bigint not null,
    primary key (id)
);

create table user_role (
    user_id bigint not null,
    role_id bigint not null
);

alter table graph_analysis_result add constraint UK3fks1t2njrbohyj9k7f697j8m unique (user_graph_id, algorithm_type);
alter table graph_analysis_result add constraint FK2bsvh058nl2ifcwjr9ev3b845 foreign key (user_graph_id) references uploaded_graph (id);
alter table uploaded_graph add constraint FKfywjn08nfrs59iqtj6bdq6q7i foreign key (user_id) references app_user (id);
alter table user_role add constraint FKa68196081fvovjhkek5m97n3y foreign key (role_id) references role (id);
alter table user_role add constraint FKg7fr1r7o0fkk41nfhnjdyqn7b foreign key (user_id) references app_user (id);
