/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.support;

import hu.unideb.graphanalyzer.service.UserGraphService;
import hu.unideb.graphanalyzer.support.DinaSupport;
import hu.unideb.graphanalyzer.vo.GraphUploadFormat;
import hu.unideb.inf.dina.commons.model.Graph;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class GraphSupport {
    private final UserGraphService userGraphService;

    public Graph createGraph(Long id) throws IOException {
        File graphFile = this.userGraphService.getUserGraphFile(id);
        return this.createGraphFromFile(graphFile, GraphUploadFormat.CSV);
    }

    public Graph createGraphFromMultipartFile(MultipartFile graphFile, GraphUploadFormat format) throws IOException {
        Graph graph = new Graph();
        DinaSupport.getGraphReaderForFileFormat((GraphUploadFormat)format).readGraphFromInputStream(graphFile.getInputStream(), graph);
        return graph;
    }

    public Graph createGraphFromFile(File graphFile, GraphUploadFormat format) {
        Graph graph = new Graph();
        DinaSupport.getGraphReaderForFileFormat((GraphUploadFormat)format).readGraphFromFile(graphFile, graph);
        return graph;
    }

    public GraphSupport(UserGraphService userGraphService) {
        this.userGraphService = userGraphService;
    }
}

