/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.support;

import com.google.common.base.Predicate;
import hu.unideb.inf.dina.commons.analysis.GraphAnalyzer;
import hu.unideb.inf.dina.commons.analysis.GraphAnalyzerDiscoverer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class GraphAnalyzerSupport
implements GraphAnalyzerDiscoverer {
    private Reflections ref;

    public void init(@NotNull ClassLoader classLoader) {
        String packageName = "hu.unideb.inf.dina.v2.algorithms";
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[]{classLoader})).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setScanners(new Scanner[]{new SubTypesScanner(false)});
        configurationBuilder.addClassLoader(classLoader);
        this.ref = new Reflections((Configuration)configurationBuilder);
    }

    @NotNull
    public List<GraphAnalyzer> getGraphAnalyzers() {
        return this.getGraphAnalyzerClasses().stream().map(arg_0 -> this.createInstance(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public GraphAnalyzer getGraphAnalyzer(@NotNull String id) {
        return this.getGraphAnalyzerClasses().stream().filter(clazz -> clazz.getName().equals(id)).findFirst().map(arg_0 -> this.createInstance(arg_0)).orElseThrow(RuntimeException::new);
    }

    private Set<Class<? extends GraphAnalyzer>> getGraphAnalyzerClasses() {
        return this.ref.getSubTypesOf(GraphAnalyzer.class);
    }

    private GraphAnalyzer createInstance(Class<? extends GraphAnalyzer> clazz) {
        return Stream.of(clazz.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).findFirst().map(constructor -> {
            try {
                return (GraphAnalyzer)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).orElseThrow(RuntimeException::new);
    }
}

