/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.support;

import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.support.DinaSupport;
import hu.unideb.graphanalyzer.support.GraphAnalyzerSupport;
import hu.unideb.graphanalyzer.vo.GraphUploadFormat;
import hu.unideb.inf.dina.commons.analysis.GraphAnalyzerDiscoverer;
import hu.unideb.inf.dina.commons.reader.FileGraphReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DinaSupport {
    private static final Logger log = LoggerFactory.getLogger(DinaSupport.class);
    private static URLClassLoader loader;

    public static FileGraphReader getGraphReaderForFileFormat(GraphUploadFormat format) {
        try {
            URLClassLoader loader = DinaSupport.getLoader();
            StringBuilder nameBuilder = new StringBuilder("hu.unideb.inf.dina.");
            switch (1.$SwitchMap$hu$unideb$graphanalyzer$vo$GraphUploadFormat[format.ordinal()]) {
                case 1: {
                    nameBuilder.append("GMLGraphReader");
                    break;
                }
                default: {
                    nameBuilder.append("VertexPairGraphReader");
                }
            }
            Class<?> clazz = Class.forName(nameBuilder.toString(), false, loader);
            return (FileGraphReader)DinaSupport.createInstance(clazz);
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            throw new GraphAnalyzerException("Invalid DiNA SDK found");
        }
    }

    public static GraphAnalyzerDiscoverer getGraphAnalyzerDiscoverer() {
        try {
            GraphAnalyzerSupport graphAnalyzerSupport = new GraphAnalyzerSupport();
            graphAnalyzerSupport.init((ClassLoader)DinaSupport.getLoader());
            return graphAnalyzerSupport;
        }
        catch (MalformedURLException e) {
            throw new GraphAnalyzerException("Invalid DiNA SDK found");
        }
    }

    public static void reloadSDK() {
        DinaSupport.reloadSDK(null);
    }

    public static void reloadSDK(Long id) {
        try {
            DinaSupport.clearSDK();
            if (id == null) {
                DinaSupport.loadSDK();
            } else {
                DinaSupport.loadSDK((String)("DiNA-" + id));
            }
            log.debug("SDK reloaded with new version");
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GraphAnalyzerException("Invalid DiNA SDK found");
        }
    }

    private static URLClassLoader getLoader() throws MalformedURLException {
        if (loader == null) {
            DinaSupport.loadSDK();
        }
        return loader;
    }

    private static void clearSDK() throws IOException {
        if (loader != null) {
            loader.close();
        }
    }

    private static void loadSDK() throws MalformedURLException {
        DinaSupport.loadSDK((String)"DiNA");
    }

    private static void loadSDK(String fileName) throws MalformedURLException {
        loader = DinaSupport.loadLibrary((File)Paths.get("jars/" + fileName + ".jar", new String[0]).toFile());
    }

    private static URLClassLoader loadLibrary(File file) throws MalformedURLException {
        if (file.exists()) {
            URL url = file.toURI().toURL();
            return new URLClassLoader(new URL[]{url}, FileGraphReader.class.getClassLoader());
        }
        throw new GraphAnalyzerException("Specified SDK version does not exist");
    }

    private static Object createInstance(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).findFirst().map(constructor -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).orElseThrow(RuntimeException::new);
    }
}

