/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.sse;

import hu.unideb.graphanalyzer.sse.ClientNotification;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class ClientNotifier {
    private final Map<String, SseEmitter> clients = new HashMap();

    SseEmitter addClient(String clientId) {
        SseEmitter sseEmitter = new SseEmitter();
        this.clients.put(clientId, sseEmitter);
        return sseEmitter;
    }

    public void sendNotification(String userId, Long userGraphId, ClientNotification notification) {
        SseEmitter client = (SseEmitter)this.clients.get(userId);
        if (client != null) {
            try {
                SseEmitter.SseEventBuilder data = SseEmitter.event().id(userGraphId.toString()).data((Object)notification, MediaType.APPLICATION_JSON);
                client.send(data);
            }
            catch (IOException ignore) {
                this.clients.remove(userId);
            }
        }
    }
}

