/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.service.rewrite.impl;

import hu.unideb.graphanalyzer.dto.AnalysisResultDTO;
import hu.unideb.graphanalyzer.dto.DinaAlgorithmDTO;
import hu.unideb.graphanalyzer.entity.GraphAnalysisResult;
import hu.unideb.graphanalyzer.entity.UserGraph;
import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.repository.GraphAnalysisResultRepository;
import hu.unideb.graphanalyzer.rest.response.ResponseStatus;
import hu.unideb.graphanalyzer.service.UserGraphService;
import hu.unideb.graphanalyzer.service.rewrite.GraphAnalyzerService;
import hu.unideb.graphanalyzer.service.rewrite.RunningAnalysisProcessHolderRewrite;
import hu.unideb.graphanalyzer.service.rewrite.RunningAnalysisRewrite;
import hu.unideb.graphanalyzer.sse.rewrite.ClientNotificationRewrite;
import hu.unideb.graphanalyzer.sse.rewrite.ClientNotifierRewrite;
import hu.unideb.graphanalyzer.support.DinaSupport;
import hu.unideb.graphanalyzer.support.GraphSupport;
import hu.unideb.inf.dina.commons.analysis.GraphAnalyzer;
import hu.unideb.inf.dina.commons.exception.GraphReaderException;
import hu.unideb.inf.dina.commons.model.Graph;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GraphAnalyzerServiceImplRewrite
implements GraphAnalyzerService {
    private static final Logger log = LoggerFactory.getLogger(GraphAnalyzerServiceImplRewrite.class);
    private final UserGraphService userGraphService;
    private final GraphAnalysisResultRepository graphAnalysisResultRepository;
    private final RunningAnalysisProcessHolderRewrite runningAnalysisProcessHolder;
    private final GraphSupport graphSupport;
    private final ClientNotifierRewrite clientNotifier;

    @Async
    @Transactional
    public void runAnalysisAsync(String algorithmId, Long userGraphId) {
        GraphAnalyzer graphAnalyzer;
        UserGraph userGraph = this.userGraphService.getUserGraph(userGraphId);
        String userId = userGraph.getUser().getEmail();
        RunningAnalysisRewrite analysis = new RunningAnalysisRewrite(userId, userGraphId, algorithmId, (graphAnalyzer = DinaSupport.getGraphAnalyzerDiscoverer().getGraphAnalyzer(algorithmId)).getName());
        if (this.runningAnalysisProcessHolder.isProcessAlreadyRunning(analysis)) {
            log.info(analysis + " is already running, not started");
            return;
        }
        if (!this.runningAnalysisProcessHolder.isProcessAllowedToStart()) {
            ClientNotificationRewrite notification = ClientNotificationRewrite.builder().algorithmId(analysis.getAlgorithmId()).algorithmType(analysis.getAlgorithmType()).status(ResponseStatus.OK).build();
            this.clientNotifier.sendNotification(analysis.getUserId(), analysis.getUserGraphId(), notification);
        } else {
            this.runningAnalysisProcessHolder.startProcess(analysis);
            try {
                log.info("Starting process " + algorithmId + " on " + userGraphId + " UserGraph");
                List results = graphAnalyzer.analyze(this.createGraph(userGraph)).stream().map(analysisResult -> AnalysisResultDTO.builder().type(analysisResult.getClass().getSimpleName()).data(analysisResult.get()).build()).collect(Collectors.toList());
                log.info("Process finished " + algorithmId + " on " + userGraphId + " UserGraph");
                GraphAnalysisResult graphAnalysisResult = (GraphAnalysisResult)this.graphAnalysisResultRepository.save((Object)new GraphAnalysisResult(userGraph, algorithmId));
                this.userGraphService.saveResultToFile(graphAnalysisResult.getId().toString(), results);
                this.runningAnalysisProcessHolder.endProcess(analysis);
                log.info("Result saved " + algorithmId + " of " + userGraphId + " UserGraph");
            }
            catch (GraphReaderException e) {
                log.error(e.getMessage());
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                this.runningAnalysisProcessHolder.endProcessWithError(analysis, (Exception)((Object)e));
            }
            catch (IOException e) {
                String message = "Error during the analysis result of " + algorithmId + " " + userGraphId + " UserGraph";
                log.error(message);
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                this.runningAnalysisProcessHolder.endProcessWithError(analysis);
                throw new GraphAnalyzerException(message);
            }
        }
    }

    public List<AnalysisResultDTO> getResults(String algorithmId, Long userGraphId) {
        Optional result = this.graphAnalysisResultRepository.findByUserGraphIdAndAlgorithmType(userGraphId, algorithmId);
        return (List)this.userGraphService.loadResultFromFile(((GraphAnalysisResult)result.get()).getId().toString(), List.class);
    }

    public List<DinaAlgorithmDTO> getAnalyzers() {
        List graphAnalyzers = DinaSupport.getGraphAnalyzerDiscoverer().getGraphAnalyzers();
        return graphAnalyzers.stream().map(graphAnalyzer -> DinaAlgorithmDTO.builder().id(graphAnalyzer.getClass().getName()).name(graphAnalyzer.getName()).description(graphAnalyzer.getDescription()).build()).collect(Collectors.toList());
    }

    private Graph createGraph(UserGraph userGraph) throws IOException {
        File graphFile = this.userGraphService.getUserGraphFile(userGraph.getId());
        return this.graphSupport.createGraphFromFile(graphFile, userGraph.getFormat());
    }

    public GraphAnalyzerServiceImplRewrite(UserGraphService userGraphService, GraphAnalysisResultRepository graphAnalysisResultRepository, RunningAnalysisProcessHolderRewrite runningAnalysisProcessHolder, GraphSupport graphSupport, ClientNotifierRewrite clientNotifier) {
        this.userGraphService = userGraphService;
        this.graphAnalysisResultRepository = graphAnalysisResultRepository;
        this.runningAnalysisProcessHolder = runningAnalysisProcessHolder;
        this.graphSupport = graphSupport;
        this.clientNotifier = clientNotifier;
    }
}

