/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.service.rewrite;

import hu.unideb.graphanalyzer.rest.response.ResponseStatus;
import hu.unideb.graphanalyzer.service.SDKService;
import hu.unideb.graphanalyzer.service.rewrite.RunningAnalysisRewrite;
import hu.unideb.graphanalyzer.sse.rewrite.ClientNotificationRewrite;
import hu.unideb.graphanalyzer.sse.rewrite.ClientNotifierRewrite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RunningAnalysisProcessHolderRewrite {
    private static final Logger log = LoggerFactory.getLogger(RunningAnalysisProcessHolderRewrite.class);
    private final SDKService sdkService;
    private final ClientNotifierRewrite clientNotifier;
    private final List<RunningAnalysisRewrite> runningProcesses = Collections.synchronizedList(new ArrayList());
    private Long idForScheduledUpdate = null;

    public void scheduleUpdate(Long id) {
        this.idForScheduledUpdate = id;
        this.checkForUpdate();
    }

    public boolean isProcessAlreadyRunning(RunningAnalysisRewrite runningAnalysis) {
        return this.runningProcesses.contains(runningAnalysis);
    }

    public boolean isProcessAllowedToStart() {
        return this.idForScheduledUpdate == null;
    }

    public void startProcess(RunningAnalysisRewrite analysis) {
        this.runningProcesses.add(analysis);
        log.info("Process added to running processes " + analysis);
    }

    public void endProcess(RunningAnalysisRewrite analysis) {
        ClientNotificationRewrite notification = ClientNotificationRewrite.builder().algorithmId(analysis.getAlgorithmId()).algorithmType(analysis.getAlgorithmType()).status(ResponseStatus.OK).build();
        this.clientNotifier.sendNotification(analysis.getUserId(), analysis.getUserGraphId(), notification);
        this.runningProcesses.remove(analysis);
        log.info("Process removed from running processes" + analysis);
        this.checkForUpdate();
    }

    public void endProcessWithError(RunningAnalysisRewrite analysis) {
        this.endProcessWithError(analysis, null);
        this.checkForUpdate();
    }

    public void endProcessWithError(RunningAnalysisRewrite analysis, Exception ex) {
        String errorMessage = ex == null ? null : ex.getMessage();
        ClientNotificationRewrite notification = ClientNotificationRewrite.builder().algorithmId(analysis.getAlgorithmId()).algorithmType(analysis.getAlgorithmType()).status(ResponseStatus.FAILED).message(errorMessage).build();
        this.clientNotifier.sendNotification(analysis.getUserId(), analysis.getUserGraphId(), notification);
        this.runningProcesses.remove(analysis);
        log.info("Process finished with error and from running processes" + analysis);
        this.checkForUpdate();
    }

    public List<RunningAnalysisRewrite> getRunningProcessesOfUserGraph(Long userGraphId) {
        return this.runningProcesses.stream().filter(process -> process.getUserGraphId().equals(userGraphId)).collect(Collectors.toList());
    }

    private void checkForUpdate() {
        if (this.idForScheduledUpdate != null && this.runningProcesses.size() == 0) {
            this.sdkService.reload(this.idForScheduledUpdate);
            this.idForScheduledUpdate = null;
        }
    }

    public RunningAnalysisProcessHolderRewrite(SDKService sdkService, ClientNotifierRewrite clientNotifier) {
        this.sdkService = sdkService;
        this.clientNotifier = clientNotifier;
    }
}

