/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.service.impl;

import hu.unideb.graphanalyzer.dto.UserDTO;
import hu.unideb.graphanalyzer.entity.Role;
import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.mapper.UserMapper;
import hu.unideb.graphanalyzer.repository.RoleRepository;
import hu.unideb.graphanalyzer.repository.UserRepository;
import hu.unideb.graphanalyzer.service.UserGraphService;
import hu.unideb.graphanalyzer.service.UserService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
public class UserServiceImpl
implements UserService {
    private final UserRepository userRepository;
    private final UserGraphService userGraphService;
    private final RoleRepository roleRepository;
    private final PasswordEncoder passwordEncoder;

    public UserServiceImpl(UserRepository userRepository, UserGraphService userGraphService, RoleRepository roleRepository, PasswordEncoder passwordEncoder) {
        this.userRepository = userRepository;
        this.userGraphService = userGraphService;
        this.roleRepository = roleRepository;
        this.passwordEncoder = passwordEncoder;
    }

    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        hu.unideb.graphanalyzer.entity.User user = (hu.unideb.graphanalyzer.entity.User)this.userRepository.findByEmail(email).orElseThrow(() -> new UsernameNotFoundException(String.format("The email %s doesn't exist", email)));
        return new User(user.getEmail(), user.getPassword(), (Collection)user.getAuthorities());
    }

    public hu.unideb.graphanalyzer.entity.User register(UserDTO userDTO) {
        this.checkEmailExists(userDTO.getEmail());
        hu.unideb.graphanalyzer.entity.User user = UserMapper.toEntity((UserDTO)userDTO);
        user.setRoles(Collections.singletonList((Role)this.roleRepository.findByRoleName("GENERAL_USER").orElseThrow(() -> new GraphAnalyzerException("General user role not found."))));
        user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        hu.unideb.graphanalyzer.entity.User saved = (hu.unideb.graphanalyzer.entity.User)this.userRepository.save((Object)user);
        return saved;
    }

    public hu.unideb.graphanalyzer.entity.User update(hu.unideb.graphanalyzer.entity.User user) {
        return (hu.unideb.graphanalyzer.entity.User)this.userRepository.save((Object)user);
    }

    private void checkEmailExists(String email) {
        Optional user = this.findByEmail(email);
        if (user.isPresent()) {
            throw new GraphAnalyzerException("Email already exists!");
        }
    }

    public Optional<hu.unideb.graphanalyzer.entity.User> findByEmail(String username) {
        return this.userRepository.findByEmail(username);
    }

    public void deleteByEmail(List<String> usernames) {
        Optional usersOptional = this.userRepository.findAllByEmailIn(usernames);
        if (usersOptional.isPresent()) {
            List users = (List)usersOptional.get();
            for (hu.unideb.graphanalyzer.entity.User user : users) {
                this.userGraphService.deleteAll(user);
                this.userRepository.delete((Object)user);
            }
        }
    }

    public List<hu.unideb.graphanalyzer.entity.User> findAll() {
        return this.userRepository.findAll();
    }

    public void changePassword(String email, String oldPassword, String newPassword) {
        hu.unideb.graphanalyzer.entity.User user;
        Optional userOptional = this.findByEmail(email);
        if (userOptional.isPresent()) {
            user = (hu.unideb.graphanalyzer.entity.User)userOptional.get();
            if (!this.passwordEncoder.matches((CharSequence)oldPassword, user.getPassword())) {
                throw new GraphAnalyzerException("Invalid password!");
            }
        } else {
            throw new GraphAnalyzerException("User not found!");
        }
        user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
        this.userRepository.save((Object)user);
    }

    public String resetPassword(String email) {
        Optional userOptional = this.findByEmail(email);
        if (userOptional.isPresent()) {
            hu.unideb.graphanalyzer.entity.User user = (hu.unideb.graphanalyzer.entity.User)userOptional.get();
            String newPassword = this.generateNewPassword();
            user.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
            this.userRepository.save((Object)user);
            return newPassword;
        }
        throw new GraphAnalyzerException("User not found!");
    }

    private String generateNewPassword() {
        int leftLimit = 48;
        int rightLimit = 122;
        Random random = new Random();
        int targetStringLength = random.ints(10, 17).findFirst().getAsInt();
        return random.ints(leftLimit, rightLimit + 1).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(targetStringLength).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

