/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.service.impl;

import com.google.gson.Gson;
import hu.unideb.graphanalyzer.configuration.FileStorageProperties;
import hu.unideb.graphanalyzer.dto.UserGraphDTO;
import hu.unideb.graphanalyzer.entity.GraphAnalysisResult;
import hu.unideb.graphanalyzer.entity.User;
import hu.unideb.graphanalyzer.entity.UserGraph;
import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.repository.GraphAnalysisResultRepository;
import hu.unideb.graphanalyzer.repository.UserGraphRepository;
import hu.unideb.graphanalyzer.service.UserGraphService;
import hu.unideb.graphanalyzer.vo.GraphUploadFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.multipart.MultipartFile;

@Service
@Validated
public class UserGraphServiceImpl
implements UserGraphService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UserGraphServiceImpl.class);
    private final UserGraphRepository userGraphRepository;
    private final GraphAnalysisResultRepository graphAnalysisResultRepository;
    private final FileStorageProperties fileStorageProperties;

    public void afterPropertiesSet() throws IOException {
        Files.createDirectories(this.fileStorageProperties.getUploadPath(), new FileAttribute[0]);
        Files.createDirectories(this.fileStorageProperties.getAnalysisResultPath(), new FileAttribute[0]);
    }

    public UserGraphDTO save(MultipartFile file, User user, GraphUploadFormat format) {
        UserGraph userGraph = (UserGraph)this.userGraphRepository.save((Object)new UserGraph(user, file.getOriginalFilename(), format));
        Path targetLocation = this.fileStorageProperties.getUploadPath().resolve(userGraph.getId() + ".bin");
        try {
            Files.copy(file.getInputStream(), targetLocation, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GraphAnalyzerException(e.getMessage());
        }
        return new UserGraphDTO(userGraph);
    }

    public File getUserGraphFile(Long id) throws FileNotFoundException {
        Path path = this.fileStorageProperties.getUploadPath().resolve(id + ".bin");
        File file = new File(path.toUri());
        if (!file.exists()) {
            throw new FileNotFoundException("Graph file not exists!");
        }
        return file;
    }

    public UserGraph getUserGraph(Long id) {
        return (UserGraph)this.userGraphRepository.findById((Object)id).orElseThrow(() -> new GraphAnalyzerException("Graph of user can not be found!"));
    }

    public List<UserGraphDTO> findAllByUser(User user) {
        return this.userGraphRepository.findAllByUser(user).stream().map(UserGraphDTO::new).collect(Collectors.toList());
    }

    public void delete(List<Long> ids) {
        List graphs = this.userGraphRepository.findAllByIdIn(ids);
        this.deleteGraphs(graphs);
    }

    public void deleteAll(User user) {
        List graphs = this.userGraphRepository.findAllByUser(user);
        this.deleteGraphs(graphs);
    }

    public void saveResultToFile(@NotNull String fileName, @NotNull Object result) throws IOException {
        Path path = this.fileStorageProperties.getAnalysisResultPath().resolve(fileName + ".bin");
        File resultFile = new File(path.toUri());
        String json = new Gson().toJson(result);
        try (FileOutputStream fileOutputStream = new FileOutputStream(resultFile);){
            fileOutputStream.write(json.getBytes());
            fileOutputStream.flush();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    public <T> T loadResultFromFile(String fileName, Class<T> type) {
        String json;
        try {
            String receiveString;
            Path result = this.fileStorageProperties.getAnalysisResultPath().resolve(fileName + ".bin");
            File analysisResult = new File(result.toUri());
            FileInputStream inputStream = new FileInputStream(analysisResult);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((receiveString = bufferedReader.readLine()) != null) {
                stringBuilder.append(receiveString);
            }
            ((InputStream)inputStream).close();
            json = stringBuilder.toString();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GraphAnalyzerException("Error during reading analysis result from file");
        }
        return (T)new Gson().fromJson(json, type);
    }

    protected void deleteGraphs(List<UserGraph> graphs) {
        for (UserGraph graph : graphs) {
            File file;
            List analysisResults = this.graphAnalysisResultRepository.findAllByUserGraphId(graph.getId());
            for (GraphAnalysisResult result : analysisResults) {
                Path analysisResultPath = this.fileStorageProperties.getAnalysisResultPath().resolve(result.getId() + ".bin");
                File analysisResult = new File(analysisResultPath.toUri());
                if (analysisResult.exists() && !analysisResult.delete()) {
                    throw new GraphAnalyzerException("Graph result file can not be deleted!");
                }
                this.graphAnalysisResultRepository.delete((Object)result);
            }
            try {
                file = this.getUserGraphFile(graph.getId());
            }
            catch (FileNotFoundException e) {
                this.userGraphRepository.delete((Object)graph);
                return;
            }
            boolean deleted = file.delete();
            if (!deleted) {
                throw new GraphAnalyzerException("Graph file can not be deleted!");
            }
            this.userGraphRepository.delete((Object)graph);
        }
    }

    public UserGraphServiceImpl(UserGraphRepository userGraphRepository, GraphAnalysisResultRepository graphAnalysisResultRepository, FileStorageProperties fileStorageProperties) {
        this.userGraphRepository = userGraphRepository;
        this.graphAnalysisResultRepository = graphAnalysisResultRepository;
        this.fileStorageProperties = fileStorageProperties;
    }
}

