/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.service.impl;

import hu.unideb.graphanalyzer.configuration.FileStorageProperties;
import hu.unideb.graphanalyzer.dto.SdkVersionDTO;
import hu.unideb.graphanalyzer.entity.SdkVersion;
import hu.unideb.graphanalyzer.entity.User;
import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.repository.SdkRepository;
import hu.unideb.graphanalyzer.service.SDKService;
import hu.unideb.graphanalyzer.support.DinaSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.multipart.MultipartFile;

@Service
@Validated
public class SDKServiceImpl
implements SDKService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SDKServiceImpl.class);
    private final FileStorageProperties fileStorageProperties;
    private final SdkRepository sdkRepository;

    public void afterPropertiesSet() throws Exception {
        Files.createDirectories(this.fileStorageProperties.getSdkPath(), new FileAttribute[0]);
        Long versionId = this.getCurrentVersion();
        if (versionId != null) {
            log.info("Loading SDK version: " + versionId);
            DinaSupport.reloadSDK((Long)versionId);
        } else {
            log.info("Loading original SDK version");
            DinaSupport.reloadSDK();
        }
    }

    public Long save(MultipartFile file, User user) {
        SdkVersion version = (SdkVersion)this.sdkRepository.save((Object)new SdkVersion(file.getOriginalFilename(), user, Boolean.valueOf(false), Boolean.valueOf(false)));
        Path targetLocation = this.fileStorageProperties.getSdkPath().resolve("DiNA-" + version.getId() + ".jar");
        try {
            Files.copy(file.getInputStream(), targetLocation, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GraphAnalyzerException("Failed to save new SDK file");
        }
        return version.getId();
    }

    public void reload(Long id) {
        if (id == 0L) {
            DinaSupport.reloadSDK();
        } else {
            DinaSupport.reloadSDK((Long)id);
        }
        this.setNewLoadedVersion(id);
    }

    public List<SdkVersionDTO> list() {
        return this.sdkRepository.findAll().stream().map(SdkVersionDTO::new).collect(Collectors.toList());
    }

    public Long getCurrentVersion() {
        Optional sdkVersionOptional = this.sdkRepository.findSdkVersionByIsLoadedIsTrue();
        return sdkVersionOptional.map(sdkVersion -> sdkVersion.getId()).orElse(null);
    }

    public void delete(List<Long> ids) {
        List versions = this.sdkRepository.findAllByIdInAndIsLoadedIsFalseAndIsOriginalIsFalse(ids);
        this.deleteVersions(versions);
    }

    public void clear() {
        this.sdkRepository.findSdkVersionByIsOriginalIsFalseAndIsLoadedIsFalse().ifPresent(arg_0 -> this.deleteVersions(arg_0));
    }

    public boolean setAsOriginal(Long id) {
        Path sourceLocation = this.fileStorageProperties.getSdkPath().resolve("DiNA-" + id + ".jar");
        Path targetLocation = this.fileStorageProperties.getSdkPath().resolve("DiNA.jar");
        try {
            Files.copy(sourceLocation, targetLocation, StandardCopyOption.REPLACE_EXISTING);
            this.setNewOriginalVersion(id);
            return this.sdkRepository.findSdkVersionByIsLoadedIsTrue().isEmpty();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new GraphAnalyzerException(e.getMessage());
        }
    }

    protected void deleteVersions(List<SdkVersion> versions) {
        for (SdkVersion version : versions) {
            Path targetLocation = this.fileStorageProperties.getSdkPath().resolve("DiNA-" + version.getId() + ".jar");
            try {
                Files.delete(targetLocation);
                this.sdkRepository.delete((Object)version);
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new GraphAnalyzerException(e.getMessage());
            }
        }
    }

    @Transactional
    void setNewLoadedVersion(Long id) {
        Optional loadedSdkVersionOptional = this.sdkRepository.findSdkVersionByIsLoadedIsTrue();
        if (loadedSdkVersionOptional.isPresent()) {
            SdkVersion loadedSdkVersion = (SdkVersion)loadedSdkVersionOptional.get();
            loadedSdkVersion.setIsLoaded(Boolean.valueOf(false));
            this.sdkRepository.save((Object)loadedSdkVersion);
        }
        Optional sdkVersionOptional = Optional.empty();
        if (id == 0L) {
            sdkVersionOptional = this.sdkRepository.findSdkVersionByIsOriginalIsTrue();
        }
        if (sdkVersionOptional.isEmpty()) {
            sdkVersionOptional = this.sdkRepository.findById((Object)id);
        }
        if (sdkVersionOptional.isPresent()) {
            SdkVersion sdkVersion = (SdkVersion)sdkVersionOptional.get();
            sdkVersion.setIsLoaded(Boolean.valueOf(true));
            this.sdkRepository.save((Object)sdkVersion);
        }
    }

    @Transactional
    void setNewOriginalVersion(Long id) {
        Optional sdkVersionOptional;
        Optional originalSdkVersionOptional = this.sdkRepository.findSdkVersionByIsOriginalIsTrue();
        if (originalSdkVersionOptional.isPresent()) {
            SdkVersion originalSdkVersion = (SdkVersion)originalSdkVersionOptional.get();
            originalSdkVersion.setIsOriginal(Boolean.valueOf(false));
            this.sdkRepository.save((Object)originalSdkVersion);
        }
        if ((sdkVersionOptional = this.sdkRepository.findById((Object)id)).isPresent()) {
            SdkVersion sdkVersion = (SdkVersion)sdkVersionOptional.get();
            sdkVersion.setIsOriginal(Boolean.valueOf(true));
            this.sdkRepository.save((Object)sdkVersion);
        }
    }

    public SDKServiceImpl(FileStorageProperties fileStorageProperties, SdkRepository sdkRepository) {
        this.fileStorageProperties = fileStorageProperties;
        this.sdkRepository = sdkRepository;
    }
}

