/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.service.impl;

import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.service.DownloadService;
import hu.unideb.graphanalyzer.service.SDKService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
@Validated
public class DownloadServiceImpl
implements DownloadService {
    private static final Logger log = LoggerFactory.getLogger(DownloadServiceImpl.class);
    private final SDKService sdkService;

    public StreamingResponseBody getStandaloneZip() {
        return out -> {
            try {
                Object sourceName;
                Long versionId = this.sdkService.getCurrentVersion();
                if (versionId != null) {
                    sourceName = "jars/DiNA-" + versionId + ".jar";
                    log.debug("Generating standalone zip with SDK version #" + versionId);
                } else {
                    sourceName = "jars/DiNA.jar";
                    log.debug("Generating standalone zip with originl SDK version");
                }
                Path source = Paths.get((String)sourceName, new String[0]);
                Path target = Paths.get("standalone/jars/DiNA.jar", new String[0]);
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                File standaloneDir = new File("standalone");
                ZipOutputStream zipOutputStream = new ZipOutputStream(out);
                this.zipFile(standaloneDir, "DiNA", zipOutputStream);
                zipOutputStream.close();
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw new GraphAnalyzerException("Failed to generate ZIP to download");
            }
        };
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public DownloadServiceImpl(SDKService sdkService) {
        this.sdkService = sdkService;
    }
}

