/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.rest.response;

import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.rest.response.ResponseStatus;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RestResponse<T> {
    private ResponseStatus status = ResponseStatus.OK;
    private List<T> data;
    private String errorCode;
    private String errorMessage;

    public static RestResponse<Void> failed(GraphAnalyzerException e) {
        return RestResponse.failed((String)"GRAPH_ANALYZER_EXCEPTION", (String)e.getMessage());
    }

    public static RestResponse<Void> failed(Exception e) {
        return RestResponse.failed((String)"INTERNAL_EXCEPTION", (String)ExceptionUtils.getStackTrace((Throwable)e));
    }

    public static RestResponse<Void> failed(String errorMessage) {
        RestResponse ret = new RestResponse();
        ret.setStatus(ResponseStatus.FAILED);
        ret.setErrorCode(null);
        ret.setErrorMessage(errorMessage);
        return ret;
    }

    public static RestResponse<Void> failed(String errorCode, String errorMessage) {
        RestResponse ret = new RestResponse();
        ret.setStatus(ResponseStatus.FAILED);
        ret.setErrorCode(errorCode == null ? "ERROR" : errorCode);
        ret.setErrorMessage(errorMessage);
        return ret;
    }

    public RestResponse() {
    }

    public RestResponse(T data) {
        if (data == null) {
            return;
        }
        this.data = Collections.singletonList(data);
    }

    public RestResponse(List<T> data) {
        this.data = data;
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public List<T> getData() {
        return this.data;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

