/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.rest.controller;

import hu.unideb.graphanalyzer.dto.ChangePasswordDTO;
import hu.unideb.graphanalyzer.dto.UserDTO;
import hu.unideb.graphanalyzer.entity.User;
import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.mapper.UserMapper;
import hu.unideb.graphanalyzer.rest.response.RestResponse;
import hu.unideb.graphanalyzer.service.UserService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/user"})
public class UserController {
    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping(value={"/list"})
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public RestResponse<UserDTO> list() {
        return new RestResponse(UserMapper.toDTO((List)this.userService.findAll()));
    }

    @PostMapping(value={"/register"})
    public RestResponse<UserDTO> register(@Valid @RequestBody UserDTO userDTO) {
        return new RestResponse((Object)UserMapper.toDTO((User)this.userService.register(userDTO)));
    }

    @PostMapping(value={"/remove"})
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public RestResponse<Void> delete(@RequestBody List<String> emails) {
        this.userService.deleteByEmail(emails);
        return new RestResponse();
    }

    @PostMapping(value={"/remove/me"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<Void> deleteSelf() {
        String email = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        this.userService.deleteByEmail(List.of(email));
        return new RestResponse();
    }

    @PostMapping(value={"/resetPassword"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN')")
    public RestResponse<String> resetPassword(@RequestBody String email) {
        String newPassword = this.userService.resetPassword(email);
        return new RestResponse((Object)newPassword);
    }

    @PostMapping(value={"/changePassword"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<Void> changePassword(@RequestBody ChangePasswordDTO changePasswordDTO) {
        String email = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        this.userService.changePassword(email, changePasswordDTO.getOldPassword(), changePasswordDTO.getNewPassword());
        return new RestResponse();
    }

    @GetMapping(value={"/me"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<UserDTO> me() {
        String principal = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return new RestResponse((Object)UserMapper.toDTO((User)((User)this.userService.findByEmail(principal).orElseThrow(() -> new GraphAnalyzerException("User not found!")))));
    }
}

