/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.rest.controller;

import hu.unideb.graphanalyzer.dto.SdkVersionDTO;
import hu.unideb.graphanalyzer.entity.User;
import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.rest.response.RestResponse;
import hu.unideb.graphanalyzer.service.SDKService;
import hu.unideb.graphanalyzer.service.UserService;
import hu.unideb.graphanalyzer.service.rewrite.RunningAnalysisProcessHolderRewrite;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/sdk/"})
public class SDKController {
    private static final Logger log = LoggerFactory.getLogger(SDKController.class);
    private final SDKService sdkService;
    private final UserService userService;
    private final RunningAnalysisProcessHolderRewrite runningAnalysisProcessHolderRewrite;

    @PostMapping(value={"/upload"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN')")
    public RestResponse<Void> upload(@RequestParam(value="file") MultipartFile file) {
        Long id = this.sdkService.save(file, this.getCurrentUser());
        this.runningAnalysisProcessHolderRewrite.scheduleUpdate(id);
        return new RestResponse();
    }

    @GetMapping(value={"/list"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN')")
    public RestResponse<SdkVersionDTO> list() {
        List dbList = this.sdkService.list();
        boolean hasOriginalSet = dbList.stream().anyMatch(SdkVersionDTO::getOriginal);
        boolean hasLoadedSet = dbList.stream().anyMatch(SdkVersionDTO::getLoaded);
        ArrayList<SdkVersionDTO> finalList = new ArrayList<SdkVersionDTO>();
        if (!hasOriginalSet) {
            finalList.add(new SdkVersionDTO(Long.valueOf(0L), "Packaged", null, null, Boolean.valueOf(true), Boolean.valueOf(!hasLoadedSet)));
        }
        finalList.addAll(dbList);
        return new RestResponse(finalList);
    }

    @PostMapping(value={"/remove"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN')")
    public RestResponse<Void> deleteVersion(@RequestBody List<Long> ids) {
        this.sdkService.delete(ids);
        return new RestResponse();
    }

    @PostMapping(value={"/clear"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN')")
    public RestResponse<Void> clearVersions() {
        this.sdkService.clear();
        return new RestResponse();
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN')")
    public RestResponse<Void> restoreVersion(@PathVariable(value="id") Long id) {
        this.runningAnalysisProcessHolderRewrite.scheduleUpdate(id);
        return new RestResponse();
    }

    @PutMapping(value={"/{id}/original"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN')")
    public RestResponse<Void> setOriginalVersion(@PathVariable(value="id") Long id) {
        boolean shouldReload = this.sdkService.setAsOriginal(id);
        if (shouldReload) {
            this.runningAnalysisProcessHolderRewrite.scheduleUpdate(id);
        }
        return new RestResponse();
    }

    private User getCurrentUser() {
        String principal = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return (User)this.userService.findByEmail(principal).orElseThrow(() -> new GraphAnalyzerException("User not found!"));
    }

    public SDKController(SDKService sdkService, UserService userService, RunningAnalysisProcessHolderRewrite runningAnalysisProcessHolderRewrite) {
        this.sdkService = sdkService;
        this.userService = userService;
        this.runningAnalysisProcessHolderRewrite = runningAnalysisProcessHolderRewrite;
    }
}

