/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.rest.controller;

import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.rest.response.ResponseStatus;
import hu.unideb.graphanalyzer.rest.response.RestResponse;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler {
    private static final Logger logger = Logger.getLogger(RestExceptionHandler.class.getSimpleName());

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    protected ResponseEntity<RestResponse> handleMethodArgumentNotValid(MethodArgumentNotValidException ex) {
        String errors = ex.getBindingResult().getFieldErrors().stream().map(e -> String.join((CharSequence)" ", e.getField(), e.getDefaultMessage())).collect(Collectors.joining(", "));
        RestResponse ret = new RestResponse();
        ret.setStatus(ResponseStatus.FAILED);
        ret.setErrorMessage(errors);
        return new ResponseEntity((Object)ret, HttpStatus.OK);
    }

    @ExceptionHandler(value={GraphAnalyzerException.class})
    protected ResponseEntity<RestResponse> handleGraphAnalyzerException(GraphAnalyzerException e) {
        logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
        return ResponseEntity.ok((Object)RestResponse.failed((GraphAnalyzerException)e));
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<RestResponse> handleException(Exception e) {
        logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
        return ResponseEntity.ok((Object)RestResponse.failed((Exception)e));
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    protected ResponseEntity<RestResponse> handleAccessDeniedException(Exception e) {
        return ResponseEntity.ok((Object)RestResponse.failed((String)e.getMessage()));
    }
}

