/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.rest.controller;

import hu.unideb.graphanalyzer.dto.UserGraphDTO;
import hu.unideb.graphanalyzer.entity.User;
import hu.unideb.graphanalyzer.exception.GraphAnalyzerException;
import hu.unideb.graphanalyzer.rest.response.RestResponse;
import hu.unideb.graphanalyzer.service.UserGraphService;
import hu.unideb.graphanalyzer.service.UserService;
import hu.unideb.graphanalyzer.support.GraphSupport;
import hu.unideb.graphanalyzer.vo.GraphUploadFormat;
import hu.unideb.inf.dina.commons.model.Graph;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/graph"})
public class GraphController {
    private static final Logger log = LoggerFactory.getLogger(GraphController.class);
    private final UserService userService;
    private final UserGraphService userGraphService;
    private final GraphSupport graphSupport;

    @PostMapping(value={"/upload/{format}"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<UserGraphDTO> upload(@RequestParam(value="file") MultipartFile file, @PathVariable(value="format") GraphUploadFormat format) throws IOException {
        RestResponse response = new RestResponse();
        Graph graph = this.graphSupport.createGraphFromMultipartFile(file, format);
        UserGraphDTO userGraphDTO = this.userGraphService.save(file, this.getCurrentUser(), format);
        response.setData(Collections.singletonList(userGraphDTO));
        return response;
    }

    @GetMapping(value={"/listUploaded"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<UserGraphDTO> listUploadedGraphs() {
        List graphs = this.userGraphService.findAllByUser(this.getCurrentUser());
        return new RestResponse(graphs);
    }

    @PostMapping(value={"/remove"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<Void> remove(@RequestBody List<Long> ids) {
        this.userGraphService.delete(ids);
        return new RestResponse();
    }

    @PostMapping(value={"/removeAll"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<Void> remove() {
        this.userGraphService.deleteAll(this.getCurrentUser());
        return new RestResponse();
    }

    private User getCurrentUser() {
        String principal = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return (User)this.userService.findByEmail(principal).orElseThrow(() -> new GraphAnalyzerException("User not found!"));
    }

    public GraphController(UserService userService, UserGraphService userGraphService, GraphSupport graphSupport) {
        this.userService = userService;
        this.userGraphService = userGraphService;
        this.graphSupport = graphSupport;
    }
}

