/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.rest.controller;

import hu.unideb.graphanalyzer.dto.AnalysisResultDTO;
import hu.unideb.graphanalyzer.dto.DinaAlgorithmDTO;
import hu.unideb.graphanalyzer.dto.v2.GraphAnalysisResult;
import hu.unideb.graphanalyzer.repository.GraphAnalysisResultRepository;
import hu.unideb.graphanalyzer.rest.response.RestResponse;
import hu.unideb.graphanalyzer.service.rewrite.GraphAnalyzerService;
import hu.unideb.graphanalyzer.service.rewrite.RunningAnalysisProcessHolderRewrite;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/algorithm"})
public class AlgorithmController {
    private static final Logger log = LoggerFactory.getLogger(AlgorithmController.class);
    private final GraphAnalyzerService graphAnalyzerService;
    private final GraphAnalysisResultRepository graphAnalysisResultRepository;
    private final RunningAnalysisProcessHolderRewrite runningAnalysisProcessHolderRewrite;

    @GetMapping(value={"/list"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<DinaAlgorithmDTO> list() {
        return new RestResponse(this.graphAnalyzerService.getAnalyzers());
    }

    @GetMapping(value={"/listResults"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<GraphAnalysisResult> listResults(@RequestParam Long userGraphId) {
        List results = this.graphAnalysisResultRepository.findAllByUserGraphId(userGraphId).stream().map(graphAnalysisResult -> GraphAnalysisResult.builder().id(graphAnalysisResult.getId()).algorithmType(graphAnalysisResult.getAlgorithmType()).status("DONE").build()).collect(Collectors.toList());
        List inProgress = this.runningAnalysisProcessHolderRewrite.getRunningProcessesOfUserGraph(userGraphId).stream().map(runningAnalysis -> GraphAnalysisResult.builder().id(null).algorithmType(runningAnalysis.getAlgorithmId()).status("IN_PROGRESS").build()).collect(Collectors.toList());
        results.addAll(inProgress);
        return new RestResponse(results);
    }

    @GetMapping(value={"/run"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<Void> run(@RequestParam String algorithmId, @RequestParam Long id) {
        this.graphAnalyzerService.runAnalysisAsync(algorithmId, id);
        return new RestResponse();
    }

    @GetMapping(value={"/getResults"})
    @PreAuthorize(value="hasAnyAuthority('ADMIN', 'GENERAL_USER')")
    public RestResponse<AnalysisResultDTO> getResults(@RequestParam Long userGraphId, @RequestParam String algorithmId) {
        return new RestResponse(this.graphAnalyzerService.getResults(algorithmId, userGraphId));
    }

    public AlgorithmController(GraphAnalyzerService graphAnalyzerService, GraphAnalysisResultRepository graphAnalysisResultRepository, RunningAnalysisProcessHolderRewrite runningAnalysisProcessHolderRewrite) {
        this.graphAnalyzerService = graphAnalyzerService;
        this.graphAnalysisResultRepository = graphAnalysisResultRepository;
        this.runningAnalysisProcessHolderRewrite = runningAnalysisProcessHolderRewrite;
    }
}

