/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.mapper;

import hu.unideb.graphanalyzer.dto.UserDTO;
import hu.unideb.graphanalyzer.entity.Role;
import hu.unideb.graphanalyzer.entity.User;
import java.util.List;
import java.util.stream.Collectors;

public class UserMapper {
    public static UserDTO toDTO(User user) {
        UserDTO userDTO = new UserDTO();
        userDTO.setId(user.getId());
        userDTO.setEmail(user.getEmail());
        userDTO.setFirstName(user.getFirstName());
        userDTO.setLastName(user.getLastName());
        userDTO.setRoles(user.getRoles().stream().map(Role::getRoleName).collect(Collectors.toList()));
        return userDTO;
    }

    public static List<UserDTO> toDTO(List<User> userList) {
        return userList.stream().map(UserMapper::toDTO).collect(Collectors.toList());
    }

    public static User toEntity(UserDTO userDTO) {
        User user = new User();
        user.setId(userDTO.getId());
        user.setEmail(userDTO.getEmail());
        user.setPassword(userDTO.getPassword());
        user.setFirstName(userDTO.getFirstName());
        user.setLastName(userDTO.getLastName());
        return user;
    }
}

