/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.entity;

import hu.unideb.graphanalyzer.entity.BaseEntity;
import hu.unideb.graphanalyzer.entity.User;
import hu.unideb.graphanalyzer.vo.GraphUploadFormat;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;

@Entity
@Table(name="UPLOADED_GRAPH")
public class UserGraph
extends BaseEntity {
    @ManyToOne(optional=false)
    @JoinColumn(name="USER_ID")
    private User user;
    @Column(name="FILE_NAME", nullable=false)
    private String fileName;
    @Column(name="UPLOAD_DATE", nullable=false)
    private LocalDateTime uploadDate;
    @Column(name="FILE_FORMAT", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private GraphUploadFormat format;

    public UserGraph(User user, String fileName, GraphUploadFormat format) {
        this.user = user;
        this.fileName = fileName;
        this.format = format;
    }

    @PrePersist
    public void onPrePersist() {
        this.uploadDate = LocalDateTime.now();
    }

    public User getUser() {
        return this.user;
    }

    public String getFileName() {
        return this.fileName;
    }

    public LocalDateTime getUploadDate() {
        return this.uploadDate;
    }

    public GraphUploadFormat getFormat() {
        return this.format;
    }

    public UserGraph() {
    }
}

