/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hu.unideb.graphanalyzer.entity.BaseEntity;
import hu.unideb.graphanalyzer.entity.Role;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Entity
@Table(name="APP_USER")
public class User
extends BaseEntity {
    private static final long serialVersionUID = -8878175513256845476L;
    @Column(name="EMAIL")
    private String email;
    @Column(name="PASSWORD")
    @JsonIgnore
    private String password;
    @Column(name="FIRST_NAME")
    private String firstName;
    @Column(name="LAST_NAME")
    private String lastName;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="USER_ROLE", joinColumns={@JoinColumn(name="USER_ID", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="ROLE_ID", referencedColumnName="ID")})
    private List<Role> roles;

    @JsonIgnore
    public List<SimpleGrantedAuthority> getAuthorities() {
        return this.getRoles().stream().map(Role::getRoleName).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }
}

