/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;

@Configuration
@EnableResourceServer
public class ResourceServerConfig
extends ResourceServerConfigurerAdapter {
    @Value(value="${security.jwt.resource-ids}")
    private String resourceIds;
    private final ResourceServerTokenServices tokenServices;

    public ResourceServerConfig(ResourceServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void configure(ResourceServerSecurityConfigurer resources) {
        resources.resourceId(this.resourceIds).tokenServices(this.tokenServices);
    }

    public void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatchers().and().authorizeRequests().antMatchers(new String[]{"/rest/oauth/authorize", "/rest/oath/token", "/rest/user/register", "/rest/subscribeForNotifications", "/rest/download/standalone"})).permitAll().antMatchers(new String[]{"/rest/**"})).authenticated();
    }
}

