/*
 * Decompiled with CFR 0.152.
 */
package hu.unideb.graphanalyzer.configuration;

import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

@Configuration
@EnableAuthorizationServer
public class AuthorizationServerConfig
extends AuthorizationServerConfigurerAdapter {
    @Value(value="${security.jwt.client-id}")
    private String clientId;
    @Value(value="${security.jwt.client-secret}")
    private String clientSecret;
    @Value(value="${security.jwt.grant-type}")
    private String grantType;
    @Value(value="${security.jwt.scope-read}")
    private String scopeRead;
    @Value(value="${security.jwt.scope-write}")
    private String scopeWrite = "write";
    @Value(value="${security.jwt.resource-ids}")
    private String resourceIds;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private JwtAccessTokenConverter accessTokenConverter;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public void configure(ClientDetailsServiceConfigurer configurer) throws Exception {
        configurer.inMemory().withClient(this.clientId).secret(this.passwordEncoder.encode((CharSequence)this.clientSecret)).authorizedGrantTypes(new String[]{this.grantType}).scopes(new String[]{this.scopeRead, this.scopeWrite}).resourceIds(new String[]{this.resourceIds});
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        TokenEnhancerChain enhancerChain = new TokenEnhancerChain();
        enhancerChain.setTokenEnhancers(Arrays.asList(this.accessTokenConverter));
        endpoints.tokenStore(this.tokenStore).accessTokenConverter((AccessTokenConverter)this.accessTokenConverter).tokenEnhancer((TokenEnhancer)enhancerChain).authenticationManager(this.authenticationManager).pathMapping("/oauth/authorize", "/rest/oauth/authorize").pathMapping("/oauth/token", "/rest/oauth/token");
    }
}

