/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd;

import org.miv.mbox.CannotPostException;
import org.miv.mbox.MBox;
import org.miv.mbox.MBoxListener;
import org.miv.mbox.MBoxStandalone;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.ParticleBoxListener;
import org.miv.pherd.ParticleFactory;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.CellSpace;
import org.miv.pherd.ntree.NTreeListener;

@Deprecated
public class ParticleBoxRunner
implements Runnable,
MBoxListener {
    protected ParticleBox pbox;
    protected MBoxStandalone inbox;
    protected int sleepMs = 1;
    protected boolean loop = true;
    protected ParticleFactory pfactory;

    public ParticleBoxRunner(int pmax, CellSpace space, CellData rootData, ParticleFactory pfactory) {
        this.pfactory = pfactory;
        this.inbox = new MBoxStandalone(this);
        this.pbox = new ParticleBox(pmax, space, rootData);
    }

    public MBox getInbox() {
        return this.inbox;
    }

    public ParticleBox getParticleBox() {
        return this.pbox;
    }

    public void setPriority(int ms) {
        this.sleepMs = ms;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processMessage(String from, Object[] data) {
        if (data.length <= 0 || !(data[0] instanceof InputProtocol)) throw new RuntimeException("unknown input protocol (len=" + data.length + ")");
        if (data[0] == InputProtocol.ADD_PARTICLE && data.length == 5) {
            Object id = data[1];
            double x = ((Float)data[2]).floatValue();
            double y = ((Float)data[3]).floatValue();
            double z = ((Float)data[4]).floatValue();
            this.pbox.addParticle(this.pfactory.newParticle(id, x, y, z));
            return;
        } else {
            if (data[0] != InputProtocol.DEL_PARTICLE || data.length != 2) throw new RuntimeException("unknown input protocol " + data[0]);
            Object id = data[1];
            this.pbox.removeParticle(id);
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        this.loop = true;
        while (this.loop) {
            this.step();
        }
    }

    public void step() {
        this.inbox.processMessages();
        this.pbox.step();
        this.sleep(this.sleepMs);
    }

    protected void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class ParticleBoxListenerAdaptater
    implements ParticleBoxListener,
    NTreeListener {
        protected MBox outbox;
        protected String from;

        public ParticleBoxListenerAdaptater(MBox outbox, String from) {
            this.outbox = outbox;
            this.from = from;
        }

        public void particleAdded(Object id, double x, double y, double z) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.PARTICLE_ADDED, id, x, y, z});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }

        public void particleMoved(Object id, double x, double y, double z) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.PARTICLE_MOVED, id, x, y, z});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }

        public void particleRemoved(Object id) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.PARTICLE_REMOVED, id});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }

        public void particleAttributeChanged(Object id, String attribute, Object newValue, boolean removed) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.PARTICLE_ATTRIBUTE_CHANGED, id, attribute, newValue, removed});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }

        public void stepFinished(int time) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.STEP_FINISHED, time});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }

        public void cellAdded(Object id, Object parentId, Anchor lo, Anchor hi, int depth, int index) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.CELL_ADDED, id, parentId, lo, hi, depth, index});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }

        public void cellRemoved(Object id) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.CELL_REMOVED, id});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }

        public void cellData(Object id, String message, Object data) {
            try {
                this.outbox.post(this.from, new Object[]{OutputProtocol.CELL_DATA, id, message, data});
            }
            catch (CannotPostException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputProtocol {
        PARTICLE_ADDED,
        PARTICLE_REMOVED,
        PARTICLE_MOVED,
        PARTICLE_ATTRIBUTE_CHANGED,
        STEP_FINISHED,
        CELL_ADDED,
        CELL_REMOVED,
        CELL_DATA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InputProtocol {
        ADD_PARTICLE,
        DEL_PARTICLE,
        EXIT;

    }
}

