/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jfree.util.HashNMap;
import org.jfree.xml.generator.SourceCollector;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.BasicTypeSupport;

public final class ModelBuilder {
    private static ModelBuilder instance;
    private Properties handlerMapping = new Properties();
    static /* synthetic */ Class class$java$lang$Object;

    public static ModelBuilder getInstance() {
        if (instance == null) {
            instance = new ModelBuilder();
        }
        return instance;
    }

    private ModelBuilder() {
    }

    public void addAttributeHandlers(Properties p) {
        this.handlerMapping.putAll((Map<?, ?>)p);
    }

    public DescriptionModel buildModel(SourceCollector c, DescriptionModel model) {
        Class base;
        Class[] classes = c.getClasses();
        if (model == null) {
            model = new DescriptionModel();
        }
        while (classes.length != 0) {
            classes = this.fillModel(classes, model);
        }
        this.fillSuperClasses(model);
        Class[] baseClasses = this.findElementTypes(model);
        HashNMap classMap = new HashNMap();
        for (int i = 0; i < baseClasses.length; ++i) {
            base = baseClasses[i];
            for (int j = 0; j < baseClasses.length; ++j) {
                Class child = baseClasses[j];
                if (Modifier.isAbstract(child.getModifiers()) || !base.isAssignableFrom(child)) continue;
                classMap.add(base, child);
            }
        }
        Iterator keys2 = classMap.keys();
        while (keys2.hasNext()) {
            ArrayList<TypeInfo> typeInfoList;
            base = (Class)keys2.next();
            Class[] childs = (Class[])classMap.toArray(base, new Class[0]);
            if (childs.length < 2) continue;
            boolean isNew = false;
            MultiplexMappingInfo mmi = model.getMappingModel().lookupMultiplexMapping(base);
            if (mmi == null) {
                mmi = new MultiplexMappingInfo(base);
                typeInfoList = new ArrayList();
                isNew = true;
            } else {
                typeInfoList = new ArrayList<TypeInfo>(Arrays.asList(mmi.getChildClasses()));
            }
            for (int i = 0; i < childs.length; ++i) {
                TypeInfo typeInfo = new TypeInfo(childs[i].getName(), childs[i]);
                if (typeInfoList.contains(typeInfo)) continue;
                typeInfoList.add(typeInfo);
            }
            mmi.setChildClasses(typeInfoList.toArray(new TypeInfo[0]));
            if (!isNew) continue;
            model.getMappingModel().addMultiplexMapping(mmi);
        }
        return model;
    }

    private Class[] findElementTypes(DescriptionModel model) {
        ArrayList<Class> baseClasses = new ArrayList<Class>();
        for (int i = 0; i < model.size(); ++i) {
            ClassDescription cd = model.get(i);
            if (!baseClasses.contains(cd.getObjectClass())) {
                baseClasses.add(cd.getObjectClass());
            }
            PropertyInfo[] properties = cd.getProperties();
            for (int p = 0; p < properties.length; ++p) {
                Class type;
                if (!properties[p].getPropertyType().equals(PropertyType.ELEMENT) || baseClasses.contains(type = properties[p].getType()) || Modifier.isFinal(type.getModifiers())) continue;
                baseClasses.add(type);
            }
        }
        return baseClasses.toArray(new Class[baseClasses.size()]);
    }

    private void fillSuperClasses(DescriptionModel model) {
        for (int i = 0; i < model.size(); ++i) {
            ClassDescription superCD;
            ClassDescription cd = model.get(i);
            Class parent = cd.getObjectClass().getSuperclass();
            if (parent == null || (superCD = model.get(parent)) == null) continue;
            cd.setSuperClass(superCD.getObjectClass());
        }
    }

    private Class[] fillModel(Class[] classes, DescriptionModel model) {
        ArrayList<Class> superClasses = new ArrayList<Class>();
        for (int i = 0; i < classes.length; ++i) {
            Class superClass = classes[i].getSuperclass();
            if (superClass != null) {
                if (!((class$java$lang$Object == null ? ModelBuilder.class$("java.lang.Object") : class$java$lang$Object).equals(superClass) || this.contains(classes, superClass) || superClasses.contains(superClass))) {
                    superClasses.add(superClass);
                }
            } else {
                superClass = class$java$lang$Object == null ? ModelBuilder.class$("java.lang.Object") : class$java$lang$Object;
            }
            try {
                BeanInfo bi = Introspector.getBeanInfo(classes[i], superClass);
                ClassDescription parent = model.get(classes[i]);
                ClassDescription cd = this.createClassDescription(bi, parent);
                if (cd == null) continue;
                model.addClassDescription(cd);
                continue;
            }
            catch (IntrospectionException ie) {
                // empty catch block
            }
        }
        return superClasses.toArray(new Class[0]);
    }

    private ClassDescription createClassDescription(BeanInfo beanInfo, ClassDescription parent) {
        ClassDescription cd;
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
        for (int i = 0; i < props.length; ++i) {
            PropertyInfo pi;
            PropertyDescriptor propertyDescriptor = props[i];
            if (parent != null && (pi = parent.getProperty(propertyDescriptor.getName())) != null) {
                properties.add(pi);
                continue;
            }
            if (props[i] instanceof IndexedPropertyDescriptor || (pi = this.createSimplePropertyInfo(props[i])) == null) continue;
            properties.add(pi);
        }
        PropertyInfo[] propArray = properties.toArray(new PropertyInfo[properties.size()]);
        if (parent != null) {
            cd = parent;
        } else {
            cd = new ClassDescription(beanInfo.getBeanDescriptor().getBeanClass());
            cd.setDescription(beanInfo.getBeanDescriptor().getShortDescription());
        }
        cd.setProperties(propArray);
        return cd;
    }

    public static boolean isValidMethod(Method method) {
        if (method == null) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers());
    }

    public PropertyInfo createSimplePropertyInfo(PropertyDescriptor pd) {
        boolean readMethod = ModelBuilder.isValidMethod(pd.getReadMethod());
        boolean writeMethod = ModelBuilder.isValidMethod(pd.getWriteMethod());
        if (!writeMethod || !readMethod) {
            return null;
        }
        PropertyInfo pi = new PropertyInfo(pd.getName(), pd.getPropertyType());
        pi.setConstrained(pd.isConstrained());
        pi.setDescription(pd.getShortDescription());
        pi.setNullable(true);
        pi.setPreserve(false);
        pi.setReadMethodAvailable(readMethod);
        pi.setWriteMethodAvailable(writeMethod);
        pi.setXmlName(pd.getName());
        if (this.isAttributeProperty(pd.getPropertyType())) {
            pi.setPropertyType(PropertyType.ATTRIBUTE);
            pi.setXmlHandler(this.getHandlerClass(pd.getPropertyType()));
        } else {
            pi.setPropertyType(PropertyType.ELEMENT);
        }
        return pi;
    }

    private boolean isAttributeProperty(Class c) {
        if (BasicTypeSupport.isBasicDataType(c)) {
            return true;
        }
        return this.handlerMapping.containsKey(c.getName());
    }

    private String getHandlerClass(Class c) {
        String handler;
        if (BasicTypeSupport.isBasicDataType(c) && (handler = BasicTypeSupport.getHandlerClass(c)) != null) {
            return handler;
        }
        return this.handlerMapping.getProperty(c.getName());
    }

    private boolean contains(Class[] cAll, Class c) {
        for (int i = 0; i < cAll.length; ++i) {
            if (!cAll[i].equals(c)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

