/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PrintStreamLogTarget;
import org.jfree.xml.generator.DefaultModelReader;
import org.jfree.xml.generator.JavaSourceCollector;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.ModelWriter;
import org.jfree.xml.generator.SplittingModelWriter;
import org.jfree.xml.generator.model.DescriptionModel;

public final class DescriptionGenerator {
    static /* synthetic */ Class class$org$jfree$xml$generator$DescriptionGenerator;

    private static Properties loadProperties(URL propertyURL) {
        Properties p = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(propertyURL.openStream());
            p.load(in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            System.err.println("Unable to load properties from " + propertyURL);
        }
        return p;
    }

    public static void main(String[] args2) throws Exception {
        Properties p;
        String handlerSource;
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        URL propertyURL = ObjectUtilities.getResourceRelative("generator.properties", class$org$jfree$xml$generator$DescriptionGenerator == null ? (class$org$jfree$xml$generator$DescriptionGenerator = DescriptionGenerator.class$("org.jfree.xml.generator.DescriptionGenerator")) : class$org$jfree$xml$generator$DescriptionGenerator);
        if (args2.length > 0) {
            File f = new File(args2[0]);
            propertyURL = f.toURL();
        }
        if ((handlerSource = (p = DescriptionGenerator.loadProperties(propertyURL)).getProperty("attributedefinition")) != null) {
            Properties handlers = DescriptionGenerator.loadProperties(new URL(propertyURL, handlerSource));
            ModelBuilder.getInstance().addAttributeHandlers(handlers);
        }
        String source = p.getProperty("sourcedirectory", ".");
        String target = p.getProperty("targetfile", "model.xml");
        DescriptionModel model = null;
        try {
            model = new DefaultModelReader().load(target);
        }
        catch (Exception e) {
            Log.debug("Unable to load default model. Ignoring...");
        }
        model = DescriptionGenerator.generate(source, p, model);
        model.prune();
        DescriptionGenerator.writeMultiFile(target, model);
        System.exit(0);
    }

    public static DescriptionModel generate(String source, Properties configuration, DescriptionModel model) {
        JavaSourceCollector jsc = new JavaSourceCollector(new File(source));
        Iterator<Object> it = configuration.keySet().iterator();
        while (it.hasNext()) {
            String pName = (String)it.next();
            if (pName.startsWith("ignore.baseclass.")) {
                jsc.addIgnoredBaseClass(configuration.getProperty(pName));
                continue;
            }
            if (!pName.startsWith("ignore.package.")) continue;
            jsc.addIgnoredPackage(configuration.getProperty(pName));
        }
        jsc.collectFiles();
        return ModelBuilder.getInstance().buildModel(jsc, model);
    }

    public static void writeSingleFile(String target, DescriptionModel model) throws IOException {
        Log.debug("Writing ...");
        ModelWriter writer = new ModelWriter();
        writer.setModel(model);
        BufferedWriter w = new BufferedWriter(new FileWriter(target));
        writer.write(w);
        ((Writer)w).close();
    }

    public static void writeMultiFile(String target, DescriptionModel model) throws IOException {
        Log.debug("Writing multiple files ...");
        SplittingModelWriter writer = new SplittingModelWriter();
        writer.setModel(model);
        writer.write(target);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

