/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.cumulative;

import java.util.HashMap;
import java.util.logging.Logger;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.Sink;
import org.graphstream.util.cumulative.CumulativeAttributes;
import org.graphstream.util.cumulative.CumulativeSpells;

public class GraphSpells
implements Sink {
    private static final Logger logger = Logger.getLogger(GraphSpells.class.getSimpleName());
    CumulativeSpells graph = new CumulativeSpells();
    CumulativeAttributes graphAttributes = new CumulativeAttributes(0.0);
    HashMap<String, CumulativeSpells> nodes = new HashMap();
    HashMap<String, CumulativeAttributes> nodesAttributes = new HashMap();
    HashMap<String, CumulativeSpells> edges = new HashMap();
    HashMap<String, CumulativeAttributes> edgesAttributes = new HashMap();
    HashMap<String, EdgeData> edgesData = new HashMap();
    double date = Double.NaN;

    public Iterable<String> getNodes() {
        return this.nodes.keySet();
    }

    public Iterable<String> getEdges() {
        return this.edges.keySet();
    }

    public CumulativeSpells getNodeSpells(String nodeId) {
        return this.nodes.get(nodeId);
    }

    public CumulativeAttributes getNodeAttributes(String nodeId) {
        return this.nodesAttributes.get(nodeId);
    }

    public CumulativeSpells getEdgeSpells(String edgeId) {
        return this.edges.get(edgeId);
    }

    public CumulativeAttributes getEdgeAttributes(String edgeId) {
        return this.edgesAttributes.get(edgeId);
    }

    public EdgeData getEdgeData(String edgeId) {
        return this.edgesData.get(edgeId);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.date = step;
        this.graphAttributes.updateDate(step);
        this.graph.updateCurrentSpell(step);
        for (String id : this.nodes.keySet()) {
            this.nodes.get(id).updateCurrentSpell(step);
            this.nodesAttributes.get(id).updateDate(step);
        }
        for (String id : this.edges.keySet()) {
            this.edges.get(id).updateCurrentSpell(step);
            this.edgesAttributes.get(id).updateDate(step);
        }
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        if (!this.nodes.containsKey(nodeId)) {
            this.nodes.put(nodeId, new CumulativeSpells());
            this.nodesAttributes.put(nodeId, new CumulativeAttributes(this.date));
        }
        this.nodes.get(nodeId).startSpell(this.date);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        if (this.nodes.containsKey(nodeId)) {
            this.nodes.get(nodeId).closeSpell();
            this.nodesAttributes.get(nodeId).remove();
        }
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        EdgeData data;
        if (!this.edges.containsKey(edgeId)) {
            this.edges.put(edgeId, new CumulativeSpells());
            this.edgesAttributes.put(edgeId, new CumulativeAttributes(this.date));
            data = new EdgeData();
            data.source = fromNodeId;
            data.target = toNodeId;
            data.directed = directed;
            this.edgesData.put(edgeId, data);
        }
        this.edges.get(edgeId).startSpell(this.date);
        data = this.edgesData.get(edgeId);
        if (!data.source.equals(fromNodeId) || !data.target.equals(toNodeId) || data.directed != directed) {
            logger.warning("An edge with this id but different properties has already be created in the past.");
        }
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        if (this.edges.containsKey(edgeId)) {
            this.edges.get(edgeId).closeSpell();
            this.edgesAttributes.get(edgeId).remove();
        }
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        for (String id : this.nodes.keySet()) {
            this.nodes.get(id).closeSpell();
            this.nodesAttributes.get(id).remove();
        }
        for (String id : this.edges.keySet()) {
            this.edges.get(id).closeSpell();
            this.edgesAttributes.get(id).remove();
        }
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.graphAttributes.set(attribute, value);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.graphAttributes.set(attribute, newValue);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.graphAttributes.remove(attribute);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.nodesAttributes.get(nodeId).set(attribute, value);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.nodesAttributes.get(nodeId).set(attribute, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.nodesAttributes.get(nodeId).remove(attribute);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.edgesAttributes.get(edgeId).set(attribute, value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.edgesAttributes.get(edgeId).set(attribute, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.edgesAttributes.get(edgeId).remove(attribute);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (String id : this.nodes.keySet()) {
            buffer.append("node#\"").append(id).append("\" ").append(this.nodes.get(id)).append(" ").append(this.nodesAttributes.get(id)).append("\n");
        }
        for (String id : this.edges.keySet()) {
            buffer.append("edge#\"").append(id).append("\" ").append(this.edges.get(id)).append("\n");
        }
        return buffer.toString();
    }

    public static void main(String ... args2) {
        GraphSpells graphSpells = new GraphSpells();
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        g.addSink(graphSpells);
        g.addNode("A");
        g.addNode("B");
        g.addNode("C");
        g.stepBegins(1.0);
        g.getNode("A").setAttribute("test1", 100);
        g.addEdge("AB", "A", "B");
        g.addEdge("AC", "A", "C");
        g.stepBegins(2.0);
        g.addEdge("CB", "C", "B");
        g.removeNode("A");
        g.stepBegins(3.0);
        g.addNode("A");
        g.addEdge("AB", "A", "B");
        g.stepBegins(4.0);
        g.removeNode("C");
        g.stepBegins(5.0);
        System.out.println(graphSpells);
    }

    public static class EdgeData {
        String source;
        String target;
        boolean directed;

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isDirected() {
            return this.directed;
        }
    }
}

