/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.spriteManager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.graph.Graph;
import org.graphstream.stream.AttributeSink;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.spriteManager.InvalidSpriteIDException;
import org.graphstream.ui.spriteManager.Sprite;
import org.graphstream.ui.spriteManager.SpriteFactory;

public class SpriteManager
implements Iterable<Sprite>,
AttributeSink {
    private static final Logger logger = Logger.getLogger(SpriteManager.class.getName());
    protected Graph graph;
    protected HashMap<String, Sprite> sprites = new HashMap();
    protected SpriteFactory factory = new SpriteFactory();
    boolean attributeLock = false;

    public SpriteManager(Graph graph) throws InvalidSpriteIDException {
        this.graph = graph;
        this.lookForExistingSprites();
        graph.addAttributeSink(this);
    }

    protected void lookForExistingSprites() throws InvalidSpriteIDException {
        if (this.graph.getAttributeCount() > 0) {
            this.graph.attributeKeys().filter(key -> key.startsWith("ui.sprite.")).forEach(key -> {
                String id = key.substring(10);
                if (id.indexOf(46) < 0) {
                    this.addSprite(id);
                } else {
                    String sattr = id.substring(id.indexOf(46) + 1);
                    Sprite s = this.getSprite(id = id.substring(0, id.indexOf(46)));
                    if (s == null) {
                        s = this.addSprite(id);
                    }
                    s.setAttribute(sattr, this.graph.getAttribute((String)key));
                }
            });
        }
    }

    public int getSpriteCount() {
        return this.sprites.size();
    }

    public boolean hasSprite(String identifier) {
        return this.sprites.get(identifier) != null;
    }

    public Sprite getSprite(String identifier) {
        return this.sprites.get(identifier);
    }

    public Iterable<? extends Sprite> sprites() {
        return this.sprites.values();
    }

    public Iterator<? extends Sprite> spriteIterator() {
        return this.sprites.values().iterator();
    }

    @Override
    public Iterator<Sprite> iterator() {
        return this.sprites.values().iterator();
    }

    public SpriteFactory getSpriteFactory() {
        return this.factory;
    }

    public void detach() {
        this.graph.removeAttributeSink(this);
        this.sprites.clear();
        this.graph = null;
    }

    public void setSpriteFactory(SpriteFactory factory) {
        this.factory = factory;
    }

    public void resetSpriteFactory() {
        this.factory = new SpriteFactory();
    }

    public Sprite addSprite(String identifier) throws InvalidSpriteIDException {
        return this.addSprite(identifier, (Values)null);
    }

    protected Sprite addSprite(String identifier, Values position) throws InvalidSpriteIDException {
        if (identifier.indexOf(46) >= 0) {
            throw new InvalidSpriteIDException("Sprite identifiers cannot contain dots.");
        }
        Sprite sprite = this.sprites.get(identifier);
        if (sprite == null) {
            this.attributeLock = true;
            sprite = this.factory.newSprite(identifier, this, position);
            this.sprites.put(identifier, sprite);
            this.attributeLock = false;
        } else if (position != null) {
            sprite.setPosition(position);
        }
        return sprite;
    }

    public <T extends Sprite> T addSprite(String identifier, Class<T> spriteClass) {
        return this.addSprite(identifier, spriteClass, null);
    }

    public <T extends Sprite> T addSprite(String identifier, Class<T> spriteClass, Values position) {
        try {
            Sprite sprite = (Sprite)spriteClass.newInstance();
            sprite.init(identifier, this, position);
            return (T)sprite;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, String.format("Error while trying to instantiate class %s.", spriteClass.getName()), e);
            return null;
        }
    }

    public void removeSprite(String identifier) {
        Sprite sprite = this.sprites.get(identifier);
        if (sprite != null) {
            this.attributeLock = true;
            this.sprites.remove(identifier);
            sprite.removed();
            this.attributeLock = false;
        }
    }

    protected static Values getPositionValue(Object value) {
        if (value instanceof Object[]) {
            Object[] values2 = (Object[])value;
            if (values2.length == 4) {
                if (values2[0] instanceof Number && values2[1] instanceof Number && values2[2] instanceof Number && values2[3] instanceof StyleConstants.Units) {
                    return new Values((StyleConstants.Units)((Object)values2[3]), ((Number)values2[0]).floatValue(), ((Number)values2[1]).floatValue(), ((Number)values2[2]).floatValue());
                }
                logger.warning("Cannot parse values[4] for sprite position.");
            } else if (values2.length == 3) {
                if (values2[0] instanceof Number && values2[1] instanceof Number && values2[2] instanceof Number) {
                    return new Values(StyleConstants.Units.GU, ((Number)values2[0]).floatValue(), ((Number)values2[1]).floatValue(), ((Number)values2[2]).floatValue());
                }
                logger.warning("Cannot parse values[3] for sprite position.");
            } else if (values2.length == 1) {
                if (values2[0] instanceof Number) {
                    return new Values(StyleConstants.Units.GU, ((Number)values2[0]).floatValue());
                }
                logger.warning(String.format("Sprite position percent is not a number.", new Object[0]));
            } else {
                logger.warning(String.format("Cannot transform value '%s' (length=%d) into a position.", Arrays.toString(values2), values2.length));
            }
        } else {
            if (value instanceof Number) {
                return new Values(StyleConstants.Units.GU, ((Number)value).floatValue());
            }
            if (value instanceof Value) {
                return new Values((Value)value);
            }
            if (value instanceof Values) {
                return new Values((Values)value);
            }
            System.err.printf("GraphicGraph : cannot place sprite with posiiton '%s' (instance of %s)%n", value, value.getClass().getName());
        }
        return null;
    }

    @Override
    public void graphAttributeAdded(String graphId, long time, String attribute, Object value) {
        String spriteId;
        if (this.attributeLock) {
            return;
        }
        if (attribute.startsWith("ui.sprite.") && (spriteId = attribute.substring(10)).indexOf(46) < 0 && this.getSprite(spriteId) == null) {
            Values position = null;
            if (value != null) {
                position = SpriteManager.getPositionValue(value);
            }
            try {
                this.addSprite(spriteId, position);
            }
            catch (InvalidSpriteIDException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void graphAttributeChanged(String graphId, long time, String attribute, Object oldValue, Object newValue) {
        String spriteId;
        if (this.attributeLock) {
            return;
        }
        if (attribute.startsWith("ui.sprite.") && (spriteId = attribute.substring(10)).indexOf(46) < 0) {
            Sprite s = this.getSprite(spriteId);
            if (s != null) {
                if (newValue != null) {
                    Values position = SpriteManager.getPositionValue(newValue);
                    s.setPosition(position);
                } else {
                    logger.warning(String.format("%s changed but newValue == null ! (old=%s).", spriteId, oldValue));
                }
            } else {
                throw new IllegalStateException("Sprite changed, but not added.");
            }
        }
    }

    @Override
    public void graphAttributeRemoved(String graphId, long time, String attribute) {
        String spriteId;
        if (this.attributeLock) {
            return;
        }
        if (attribute.startsWith("ui.sprite.") && (spriteId = attribute.substring(10)).indexOf(46) < 0 && this.getSprite(spriteId) != null) {
            this.removeSprite(spriteId);
        }
    }

    @Override
    public void edgeAttributeAdded(String graphId, long time, String edgeId, String attribute, Object value) {
    }

    @Override
    public void edgeAttributeChanged(String graphId, long time, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void edgeAttributeRemoved(String graphId, long time, String edgeId, String attribute) {
    }

    @Override
    public void nodeAttributeAdded(String graphId, long time, String nodeId, String attribute, Object value) {
    }

    @Override
    public void nodeAttributeChanged(String graphId, long time, String nodeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void nodeAttributeRemoved(String graphId, long time, String nodeId, String attribute) {
    }
}

