/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.spriteManager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graphstream.graph.Element;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.spriteManager.SpriteManager;

public class Sprite
implements Element {
    protected String id;
    protected String completeId;
    protected SpriteManager manager;
    protected Values position;
    protected Element attachment;

    protected Sprite() {
    }

    protected Sprite(String id, SpriteManager manager) {
        this(id, manager, null);
    }

    protected Sprite(String id, SpriteManager manager, Values position) {
        this.init(id, manager, position);
    }

    protected void init(String id, SpriteManager manager, Values position) {
        this.id = id;
        this.completeId = String.format("ui.sprite.%s", id);
        this.manager = manager;
        if (!manager.graph.hasAttribute(this.completeId)) {
            if (position != null) {
                manager.graph.setAttribute(this.completeId, position);
                this.position = position;
            } else {
                this.position = new Values(StyleConstants.Units.GU, 0.0, 0.0, 0.0);
                manager.graph.setAttribute(this.completeId, this.position);
            }
        } else if (position != null) {
            manager.graph.setAttribute(this.completeId, position);
            this.position = position;
        } else {
            this.position = SpriteManager.getPositionValue(manager.graph.getAttribute(this.completeId));
        }
    }

    protected void removed() {
        this.manager.graph.removeAttribute(this.completeId);
        String start = String.format("%s.", this.completeId);
        if (this.attached()) {
            this.detach();
        }
        ArrayList keys2 = new ArrayList();
        this.manager.graph.attributeKeys().forEach(key -> {
            if (key.startsWith(start)) {
                keys2.add(key);
            }
        });
        for (String key2 : keys2) {
            this.manager.graph.removeAttribute(key2);
        }
    }

    public Element getAttachment() {
        return this.attachment;
    }

    public boolean attached() {
        return this.attachment != null;
    }

    public double getX() {
        if (this.position.values.size() > 0) {
            return this.position.values.get(0);
        }
        return 0.0;
    }

    public double getY() {
        if (this.position.values.size() > 1) {
            return this.position.values.get(1);
        }
        return 0.0;
    }

    public double getZ() {
        if (this.position.values.size() > 2) {
            return this.position.values.get(2);
        }
        return 0.0;
    }

    public StyleConstants.Units getUnits() {
        return this.position.units;
    }

    public void attachToNode(String id) {
        if (this.attachment != null) {
            this.detach();
        }
        this.attachment = this.manager.graph.getNode(id);
        if (this.attachment != null) {
            this.attachment.setAttribute(this.completeId, new Object[0]);
        }
    }

    public void attachToEdge(String id) {
        if (this.attachment != null) {
            this.detach();
        }
        this.attachment = this.manager.graph.getEdge(id);
        if (this.attachment != null) {
            this.attachment.setAttribute(this.completeId, new Object[0]);
        }
    }

    public void detach() {
        if (this.attachment != null) {
            this.attachment.removeAttribute(this.completeId);
            this.attachment = null;
        }
    }

    public void setPosition(double percent) {
        this.setPosition(this.position.units, percent, 0.0, 0.0);
    }

    public void setPosition(double x, double y, double z) {
        this.setPosition(this.position.units, x, y, z);
    }

    public void setPosition(StyleConstants.Units units, double x, double y, double z) {
        boolean changed = false;
        if (this.position.get(0) != x) {
            changed = true;
            this.position.setValue(0, x);
        }
        if (this.position.get(1) != y) {
            changed = true;
            this.position.setValue(1, y);
        }
        if (this.position.get(2) != z) {
            changed = true;
            this.position.setValue(2, z);
        }
        if (this.position.units != units) {
            changed = true;
            this.position.setUnits(units);
        }
        if (changed) {
            this.manager.graph.setAttribute(this.completeId, new Values(this.position));
        }
    }

    protected void setPosition(Values values2) {
        if (values2 != null) {
            int n = values2.values.size();
            if (n > 2) {
                this.setPosition(values2.units, values2.get(0), values2.get(1), values2.get(2));
            } else if (n > 0) {
                this.setPosition(values2.get(0));
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public CharSequence getLabel(String key) {
        return this.manager.graph.getLabel(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public Object getAttribute(String key) {
        return this.manager.graph.getAttribute(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public <T> T getAttribute(String key, Class<T> clazz) {
        return this.manager.graph.getAttribute(String.format("%s.%s", this.completeId, key), clazz);
    }

    @Override
    public int getAttributeCount() {
        String start = String.format("%s.", this.completeId);
        return (int)this.manager.graph.attributeKeys().filter(key -> key.startsWith(start)).count();
    }

    @Override
    public Stream<String> attributeKeys() {
        throw new RuntimeException("not implemented");
    }

    public Map<String, Object> getAttributeMap() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Object getFirstAttributeOf(String ... keys2) {
        String[] completeKeys = new String[keys2.length];
        int i = 0;
        for (String key : keys2) {
            completeKeys[i] = String.format("%s.%s", this.completeId, key);
            ++i;
        }
        return this.manager.graph.getFirstAttributeOf(completeKeys);
    }

    @Override
    public <T> T getFirstAttributeOf(Class<T> clazz, String ... keys2) {
        String[] completeKeys = new String[keys2.length];
        int i = 0;
        for (String key : keys2) {
            completeKeys[i] = String.format("%s.%s", this.completeId, key);
            ++i;
        }
        return this.manager.graph.getFirstAttributeOf(clazz, completeKeys);
    }

    @Override
    public Object[] getArray(String key) {
        return this.manager.graph.getArray(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public Map<?, ?> getMap(String key) {
        return this.manager.graph.getMap(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public double getNumber(String key) {
        return this.manager.graph.getNumber(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public List<? extends Number> getVector(String key) {
        return this.manager.graph.getVector(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.manager.graph.hasAttribute(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasArray(String key) {
        return this.manager.graph.hasArray(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasAttribute(String key, Class<?> clazz) {
        return this.manager.graph.hasAttribute(String.format("%s.%s", this.completeId, key), clazz);
    }

    @Override
    public boolean hasMap(String key) {
        return this.manager.graph.hasMap(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasLabel(String key) {
        return this.manager.graph.hasLabel(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasNumber(String key) {
        return this.manager.graph.hasNumber(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasVector(String key) {
        return this.manager.graph.hasVector(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public void setAttribute(String attribute, Object ... values2) {
        this.manager.graph.setAttribute(String.format("%s.%s", this.completeId, attribute), values2);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        for (String key : attributes.keySet()) {
            this.manager.graph.setAttribute(String.format("%s.%s", this.completeId, key), attributes.get(key));
        }
    }

    @Override
    public void clearAttributes() {
        String start = String.format("%s.", this.completeId);
        this.manager.graph.attributeKeys().filter(key -> key.startsWith(start)).collect(Collectors.toList()).forEach(key -> this.manager.graph.removeAttribute((String)key));
    }

    @Override
    public void removeAttribute(String attribute) {
        this.manager.graph.removeAttribute(String.format("%s.%s", this.completeId, attribute));
    }

    @Override
    public int getIndex() {
        return 0;
    }
}

