/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;

public class GraphicSprite
extends GraphicElement {
    protected GraphicNode node;
    protected GraphicEdge edge;
    public Values position = new Values(StyleConstants.Units.GU, 0.0, 0.0, 0.0);

    public GraphicSprite(String id, GraphicGraph graph) {
        super(id, graph);
        String myPrefix;
        if (graph.getNodeCount() > 0) {
            GraphicNode node = (GraphicNode)graph.nodes().findFirst().get();
            this.position.setValue(0, node.x);
            this.position.setValue(1, node.y);
            this.position.setValue(2, node.z);
        }
        if (this.mygraph.getAttribute(myPrefix = String.format("ui.sprite.%s", id)) == null) {
            this.mygraph.setAttribute(myPrefix, this.position);
        }
    }

    public GraphicNode getNodeAttachment() {
        return this.node;
    }

    public GraphicEdge getEdgeAttachment() {
        return this.edge;
    }

    public GraphicElement getAttachment() {
        GraphicNode n = this.getNodeAttachment();
        if (n != null) {
            return n;
        }
        return this.getEdgeAttachment();
    }

    public boolean isAttached() {
        return this.edge != null || this.node != null;
    }

    public boolean isAttachedToNode() {
        return this.node != null;
    }

    public boolean isAttachedToEdge() {
        return this.edge != null;
    }

    @Override
    public Selector.Type getSelectorType() {
        return Selector.Type.SPRITE;
    }

    @Override
    public double getX() {
        return this.position.get(0);
    }

    @Override
    public double getY() {
        return this.position.get(1);
    }

    @Override
    public double getZ() {
        return this.position.get(2);
    }

    public StyleConstants.Units getUnits() {
        return this.position.getUnits();
    }

    @Override
    public void move(double x, double y, double z) {
        if (this.isAttachedToNode()) {
            GraphicNode n = this.getNodeAttachment();
            this.setPosition(x -= n.x, y -= n.y, z -= n.z, StyleConstants.Units.GU);
        } else if (this.isAttachedToEdge()) {
            GraphicEdge e = this.getEdgeAttachment();
            double len = e.to.x - e.from.x;
            double diff = x - e.from.x;
            x = diff / len;
            this.setPosition(x);
        } else {
            this.setPosition(x, y, z, StyleConstants.Units.GU);
        }
    }

    public void attachToNode(GraphicNode node) {
        this.edge = null;
        this.node = node;
        String prefix = String.format("ui.sprite.%s", this.getId());
        if (this.node.getAttribute(prefix) == null) {
            this.node.setAttribute(prefix, new Object[0]);
        }
        this.mygraph.graphChanged = true;
    }

    public void attachToEdge(GraphicEdge edge) {
        this.node = null;
        this.edge = edge;
        String prefix = String.format("ui.sprite.%s", this.getId());
        if (this.edge.getAttribute(prefix) == null) {
            this.edge.setAttribute(prefix, new Object[0]);
        }
        this.mygraph.graphChanged = true;
    }

    public void detach() {
        String prefix = String.format("ui.sprite.%s", this.getId());
        if (this.node != null) {
            this.node.removeAttribute(prefix);
        } else if (this.edge != null) {
            this.edge.removeAttribute(prefix);
        }
        this.edge = null;
        this.node = null;
        this.mygraph.graphChanged = true;
    }

    public void setPosition(double value) {
        this.setPosition(value, 0.0, 0.0, this.getUnits());
    }

    public void setPosition(double x, double y, double z, StyleConstants.Units units) {
        if (this.edge != null) {
            if (x < 0.0) {
                x = 0.0;
            } else if (x > 1.0) {
                x = 1.0;
            }
        }
        boolean changed = false;
        if (this.getX() != x) {
            changed = true;
            this.position.setValue(0, x);
        }
        if (this.getY() != y) {
            changed = true;
            this.position.setValue(1, y);
        }
        if (this.getZ() != z) {
            changed = true;
            this.position.setValue(2, z);
        }
        if (this.getUnits() != units) {
            changed = true;
            this.position.setUnits(units);
        }
        if (changed) {
            this.mygraph.graphChanged = true;
            this.mygraph.boundsChanged = true;
            String prefix = String.format("ui.sprite.%s", this.getId());
            this.mygraph.setAttribute(prefix, this.position);
        }
    }

    public void setPosition(Values values2) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (values2.getValueCount() > 0) {
            x = values2.get(0);
        }
        if (values2.getValueCount() > 1) {
            y = values2.get(1);
        }
        if (values2.getValueCount() > 2) {
            z = values2.get(2);
        }
        if (x == 1.0 && y == 1.0 && z == 1.0) {
            throw new RuntimeException("WTF !!!");
        }
        this.setPosition(x, y, z, values2.units);
    }

    protected double checkAngle(double angle) {
        if (angle > Math.PI * 2) {
            angle %= Math.PI * 2;
        } else if (angle < 0.0) {
            angle = Math.PI * 2 - angle % (Math.PI * 2);
        }
        return angle;
    }

    @Override
    protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        super.attributeChanged(event, attribute, oldValue, newValue);
        String completeAttr = String.format("ui.sprite.%s.%s", this.getId(), attribute);
        this.mygraph.listeners.sendAttributeChangedEvent(this.mygraph.getId(), SourceBase.ElementType.GRAPH, completeAttr, event, oldValue, newValue);
    }

    @Override
    protected void removed() {
    }
}

