/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.Element;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSource;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupListener;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheet;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.view.Viewer;
import org.graphstream.util.GraphListeners;

public class GraphicGraph
extends AbstractElement
implements Graph,
StyleGroupListener {
    private static final Logger logger = Logger.getLogger(GraphicGraph.class.getSimpleName());
    protected StyleSheet styleSheet;
    protected StyleGroupSet styleGroups;
    protected final Map<GraphicNode, List<GraphicEdge>> connectivity;
    public StyleGroup style;
    public double step = 0.0;
    public boolean graphChanged;
    protected boolean boundsChanged = true;
    protected Point3 hi = new Point3();
    protected Point3 lo = new Point3();
    protected GraphListeners listeners = new GraphListeners(this);
    protected boolean feedbackXYZ = true;

    public GraphicGraph(String id) {
        super(id);
        this.styleSheet = new StyleSheet();
        this.styleGroups = new StyleGroupSet(this.styleSheet);
        this.connectivity = new HashMap<GraphicNode, List<GraphicEdge>>();
        this.styleGroups.addListener(this);
        this.styleGroups.addElement(this);
        this.style = this.styleGroups.getStyleFor(this);
    }

    public boolean graphChangedFlag() {
        return this.graphChanged;
    }

    public void resetGraphChangedFlag() {
        this.graphChanged = false;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public StyleGroup getStyle() {
        return this.style;
    }

    public StyleGroupSet getStyleGroups() {
        return this.styleGroups;
    }

    @Override
    public String toString() {
        return String.format("[%s %d nodes %d edges]", this.getId(), this.getNodeCount(), this.getEdgeCount());
    }

    @Override
    public double getStep() {
        return this.step;
    }

    public Point3 getMaxPos() {
        return this.hi;
    }

    public Point3 getMinPos() {
        return this.lo;
    }

    public boolean feedbackXYZ() {
        return this.feedbackXYZ;
    }

    public void feedbackXYZ(boolean on) {
        this.feedbackXYZ = on;
    }

    public void computeBounds() {
        if (this.boundsChanged) {
            AtomicBoolean effectiveChange = new AtomicBoolean(false);
            this.lo.z = Double.MAX_VALUE;
            this.lo.y = Double.MAX_VALUE;
            this.lo.x = Double.MAX_VALUE;
            this.hi.z = -1.7976931348623157E308;
            this.hi.y = -1.7976931348623157E308;
            this.hi.x = -1.7976931348623157E308;
            this.nodes().forEach(n -> {
                GraphicNode node = (GraphicNode)n;
                if (!node.hidden && node.positionned) {
                    effectiveChange.set(true);
                    if (node.x < this.lo.x) {
                        this.lo.x = node.x;
                    }
                    if (node.x > this.hi.x) {
                        this.hi.x = node.x;
                    }
                    if (node.y < this.lo.y) {
                        this.lo.y = node.y;
                    }
                    if (node.y > this.hi.y) {
                        this.hi.y = node.y;
                    }
                    if (node.z < this.lo.z) {
                        this.lo.z = node.z;
                    }
                    if (node.z > this.hi.z) {
                        this.hi.z = node.z;
                    }
                }
            });
            this.sprites().forEach(sprite -> {
                if (!sprite.isAttached() && sprite.getUnits() == StyleConstants.Units.GU) {
                    double x = sprite.getX();
                    double y = sprite.getY();
                    double z = sprite.getZ();
                    if (!sprite.hidden) {
                        effectiveChange.set(true);
                        if (x < this.lo.x) {
                            this.lo.x = x;
                        }
                        if (x > this.hi.x) {
                            this.hi.x = x;
                        }
                        if (y < this.lo.y) {
                            this.lo.y = y;
                        }
                        if (y > this.hi.y) {
                            this.hi.y = y;
                        }
                        if (z < this.lo.z) {
                            this.lo.z = z;
                        }
                        if (z > this.hi.z) {
                            this.hi.z = z;
                        }
                    }
                }
            });
            if (this.hi.x - this.lo.x < 1.0E-6) {
                this.hi.x += 1.0;
                this.lo.x -= 1.0;
            }
            if (this.hi.y - this.lo.y < 1.0E-6) {
                this.hi.y += 1.0;
                this.lo.y -= 1.0;
            }
            if (this.hi.z - this.lo.z < 1.0E-6) {
                this.hi.z += 1.0;
                this.lo.z -= 1.0;
            }
            if (effectiveChange.get()) {
                this.boundsChanged = false;
            } else {
                this.lo.z = -1.0;
                this.lo.y = -1.0;
                this.lo.x = -1.0;
                this.hi.z = 1.0;
                this.hi.y = 1.0;
                this.hi.x = 1.0;
            }
        }
    }

    protected void moveNode(String id, double x, double y, double z) {
        GraphicNode node = (GraphicNode)this.styleGroups.getNode(id);
        if (node != null) {
            node.x = x;
            node.y = y;
            node.z = z;
            node.setAttribute("x", x);
            node.setAttribute("y", y);
            node.setAttribute("z", z);
            this.graphChanged = true;
        }
    }

    @Override
    public Node getNode(String id) {
        return this.styleGroups.getNode(id);
    }

    @Override
    public Edge getEdge(String id) {
        return this.styleGroups.getEdge(id);
    }

    public GraphicSprite getSprite(String id) {
        return this.styleGroups.getSprite(id);
    }

    @Override
    protected void attributeChanged(AbstractElement.AttributeChangeEvent event, String attribute, Object oldValue, Object newValue) {
        if (attribute.equals("ui.repaint")) {
            this.graphChanged = true;
        } else if (attribute.equals("ui.stylesheet") || attribute.equals("stylesheet")) {
            if (event == AbstractElement.AttributeChangeEvent.ADD || event == AbstractElement.AttributeChangeEvent.CHANGE) {
                if (newValue instanceof String) {
                    try {
                        this.styleSheet.load((String)newValue);
                        this.graphChanged = true;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, String.format("Error while parsing style sheet for graph '%s'.", this.getId()), e);
                    }
                } else {
                    logger.warning(String.format("Error with stylesheet specification what to do with '%s'.", newValue));
                }
            } else {
                this.styleSheet.clear();
                this.graphChanged = true;
            }
        } else if (attribute.startsWith("ui.sprite.")) {
            this.spriteAttribute(event, null, attribute, newValue);
            this.graphChanged = true;
        }
        this.listeners.sendAttributeChangedEvent(this.getId(), SourceBase.ElementType.GRAPH, attribute, event, oldValue, newValue);
    }

    public void printConnectivity() {
        Iterator<GraphicNode> keys2 = this.connectivity.keySet().iterator();
        System.err.printf("Graphic graph connectivity:%n", new Object[0]);
        while (keys2.hasNext()) {
            GraphicNode node = keys2.next();
            System.err.printf("    [%s] -> ", node.getId());
            Iterable edges = this.connectivity.get(node);
            for (GraphicEdge edge : edges) {
                System.err.printf(" (%s %d)", edge.getId(), edge.getMultiIndex());
            }
            System.err.printf("%n", new Object[0]);
        }
    }

    @Override
    public void elementStyleChanged(Element element, StyleGroup oldStyle, StyleGroup style) {
        if (element instanceof GraphicElement) {
            GraphicElement ge = (GraphicElement)element;
            ge.style = style;
            this.graphChanged = true;
        } else if (element instanceof GraphicGraph) {
            GraphicGraph gg = (GraphicGraph)element;
            gg.style = style;
            this.graphChanged = true;
        } else {
            throw new RuntimeException("WTF ?");
        }
    }

    public void styleChanged(StyleGroup style) {
    }

    @Override
    public Stream<Node> nodes() {
        return this.styleGroups.nodes();
    }

    @Override
    public Stream<Edge> edges() {
        return this.styleGroups.edges();
    }

    public Stream<GraphicSprite> sprites() {
        return this.styleGroups.sprites();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.styleGroups.getNodeIterator();
    }

    @Override
    public void addSink(Sink listener) {
        this.listeners.addSink(listener);
    }

    @Override
    public void removeSink(Sink listener) {
        this.listeners.removeSink(listener);
    }

    @Override
    public void addAttributeSink(AttributeSink listener) {
        this.listeners.addAttributeSink(listener);
    }

    @Override
    public void removeAttributeSink(AttributeSink listener) {
        this.listeners.removeAttributeSink(listener);
    }

    @Override
    public void addElementSink(ElementSink listener) {
        this.listeners.addElementSink(listener);
    }

    @Override
    public void removeElementSink(ElementSink listener) {
        this.listeners.removeElementSink(listener);
    }

    @Override
    public Iterable<AttributeSink> attributeSinks() {
        return this.listeners.attributeSinks();
    }

    @Override
    public Iterable<ElementSink> elementSinks() {
        return this.listeners.elementSinks();
    }

    @Override
    public Edge addEdge(String id, String from, String to, boolean directed) throws IdAlreadyInUseException, ElementNotFoundException {
        GraphicEdge edge = (GraphicEdge)this.styleGroups.getEdge(id);
        if (edge == null) {
            GraphicNode n1 = (GraphicNode)this.styleGroups.getNode(from);
            GraphicNode n2 = (GraphicNode)this.styleGroups.getNode(to);
            if (n1 == null) {
                throw new ElementNotFoundException("node \"%s\"", from);
            }
            if (n2 == null) {
                throw new ElementNotFoundException("node \"%s\"", to);
            }
            edge = new GraphicEdge(id, n1, n2, directed, null);
            this.styleGroups.addElement(edge);
            List<GraphicEdge> l1 = this.connectivity.get(n1);
            List<GraphicEdge> l2 = this.connectivity.get(n2);
            if (l1 == null) {
                l1 = new ArrayList<GraphicEdge>();
                this.connectivity.put(n1, l1);
            }
            if (l2 == null) {
                l2 = new ArrayList<GraphicEdge>();
                this.connectivity.put(n2, l2);
            }
            l1.add(edge);
            l2.add(edge);
            edge.countSameEdges(l1);
            this.graphChanged = true;
            this.listeners.sendEdgeAdded(id, from, to, directed);
        }
        return edge;
    }

    @Override
    public Node addNode(String id) throws IdAlreadyInUseException {
        GraphicNode node = (GraphicNode)this.styleGroups.getNode(id);
        if (node == null) {
            node = new GraphicNode(this, id, null);
            this.styleGroups.addElement(node);
            this.graphChanged = true;
            this.listeners.sendNodeAdded(id);
        }
        return node;
    }

    @Override
    public void clear() {
        this.listeners.sendGraphCleared();
        this.clearAttributesWithNoEvent();
        this.connectivity.clear();
        this.styleGroups.clear();
        this.styleSheet.clear();
        this.step = 0.0;
        this.graphChanged = true;
        this.styleGroups.addElement(this);
        this.style = this.styleGroups.getStyleFor(this);
    }

    @Override
    public Edge removeEdge(String id) throws ElementNotFoundException {
        GraphicEdge edge = (GraphicEdge)this.styleGroups.getEdge(id);
        if (edge != null) {
            this.listeners.sendEdgeRemoved(id);
            if (this.connectivity.get(edge.from) != null) {
                this.connectivity.get(edge.from).remove(edge);
            }
            if (this.connectivity.get(edge.to) != null) {
                this.connectivity.get(edge.to).remove(edge);
            }
            this.styleGroups.removeElement(edge);
            edge.removed();
            this.graphChanged = true;
        }
        return edge;
    }

    @Override
    public Edge removeEdge(String from, String to) throws ElementNotFoundException {
        GraphicNode node0 = (GraphicNode)this.styleGroups.getNode(from);
        GraphicNode node1 = (GraphicNode)this.styleGroups.getNode(to);
        if (node0 != null && node1 != null) {
            Collection edges0 = this.connectivity.get(node0);
            Collection edges1 = this.connectivity.get(node1);
            for (GraphicEdge edge0 : edges0) {
                for (GraphicEdge edge1 : edges1) {
                    if (edge0 != edge1) continue;
                    this.removeEdge(edge0.getId());
                    return edge0;
                }
            }
        }
        return null;
    }

    @Override
    public Node removeNode(String id) throws ElementNotFoundException {
        GraphicNode node = (GraphicNode)this.styleGroups.getNode(id);
        if (node != null) {
            this.listeners.sendNodeRemoved(id);
            if (this.connectivity.get(node) != null) {
                ArrayList l = new ArrayList(this.connectivity.get(node));
                for (GraphicEdge edge : l) {
                    this.removeEdge(edge.getId());
                }
                this.connectivity.remove(node);
            }
            this.styleGroups.removeElement(node);
            node.removed();
            this.graphChanged = true;
        }
        return node;
    }

    @Override
    public Viewer display() {
        throw new RuntimeException("GraphicGraph is used by display() and cannot recursively define display()");
    }

    @Override
    public Viewer display(boolean autoLayout) {
        throw new RuntimeException("GraphicGraph is used by display() and cannot recursively define display()");
    }

    @Override
    public void stepBegins(double step) {
        this.listeners.sendStepBegins(step);
        this.step = step;
    }

    @Override
    public EdgeFactory<? extends Edge> edgeFactory() {
        throw new RuntimeException("GraphicGraph does not support EdgeFactory");
    }

    @Override
    public int getEdgeCount() {
        return this.styleGroups.getEdgeCount();
    }

    @Override
    public int getNodeCount() {
        return this.styleGroups.getNodeCount();
    }

    public int getSpriteCount() {
        return this.styleGroups.getSpriteCount();
    }

    @Override
    public boolean isAutoCreationEnabled() {
        return false;
    }

    @Override
    public NodeFactory<? extends Node> nodeFactory() {
        throw new RuntimeException("GraphicGraph does not support NodeFactory");
    }

    @Override
    public void setAutoCreate(boolean on) {
        throw new RuntimeException("GraphicGraph does not support auto-creation");
    }

    @Override
    public boolean isStrict() {
        return false;
    }

    @Override
    public void setStrict(boolean on) {
        throw new RuntimeException("GraphicGraph does not support strict checking");
    }

    @Override
    public void setEdgeFactory(EdgeFactory<? extends Edge> ef) {
        throw new RuntimeException("you cannot change the edge factory for graphic graphs !");
    }

    @Override
    public void setNodeFactory(NodeFactory<? extends Node> nf) {
        throw new RuntimeException("you cannot change the node factory for graphic graphs !");
    }

    @Override
    public void read(String filename) throws IOException {
        throw new RuntimeException("GraphicGraph does not support I/O");
    }

    @Override
    public void read(FileSource input, String filename) throws IOException {
        throw new RuntimeException("GraphicGraph does not support I/O");
    }

    @Override
    public void write(FileSink output, String filename) throws IOException {
        throw new RuntimeException("GraphicGraph does not support I/O");
    }

    @Override
    public void write(String filename) throws IOException {
        throw new RuntimeException("GraphicGraph does not support I/O");
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.listeners.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.listeners.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.listeners.graphAttributeAdded(sourceId, timeId, attribute, value);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.listeners.graphAttributeRemoved(sourceId, timeId, attribute);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.listeners.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.listeners.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.listeners.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.listeners.edgeRemoved(sourceId, timeId, edgeId);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.listeners.graphCleared(sourceId, timeId);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.listeners.nodeAdded(sourceId, timeId, nodeId);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.listeners.nodeRemoved(sourceId, timeId, nodeId);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double time) {
        this.listeners.sendStepBegins(sourceId, timeId, time);
        this.stepBegins(time);
    }

    protected void spriteAttribute(AbstractElement.AttributeChangeEvent event, Element element, String attribute, Object value) {
        GraphicSprite sprite;
        String spriteId = attribute.substring(10);
        int pos = spriteId.indexOf(46);
        String attr = null;
        if (pos > 0) {
            attr = spriteId.substring(pos + 1);
            spriteId = spriteId.substring(0, pos);
        }
        if (attr == null) {
            this.addOrChangeSprite(event, element, spriteId, value);
        } else if (event == AbstractElement.AttributeChangeEvent.ADD) {
            GraphicSprite sprite2 = this.styleGroups.getSprite(spriteId);
            if (sprite2 == null) {
                this.addOrChangeSprite(AbstractElement.AttributeChangeEvent.ADD, element, spriteId, null);
                sprite2 = this.styleGroups.getSprite(spriteId);
            }
            sprite2.setAttribute(attr, value);
        } else if (event == AbstractElement.AttributeChangeEvent.CHANGE) {
            GraphicSprite sprite3 = this.styleGroups.getSprite(spriteId);
            if (sprite3 == null) {
                this.addOrChangeSprite(AbstractElement.AttributeChangeEvent.ADD, element, spriteId, null);
                sprite3 = this.styleGroups.getSprite(spriteId);
            }
            sprite3.setAttribute(attr, value);
        } else if (event == AbstractElement.AttributeChangeEvent.REMOVE && (sprite = this.styleGroups.getSprite(spriteId)) != null) {
            sprite.removeAttribute(attr);
        }
    }

    protected void addOrChangeSprite(AbstractElement.AttributeChangeEvent event, Element element, String spriteId, Object value) {
        if (event == AbstractElement.AttributeChangeEvent.ADD || event == AbstractElement.AttributeChangeEvent.CHANGE) {
            GraphicSprite sprite = this.styleGroups.getSprite(spriteId);
            if (sprite == null) {
                sprite = this.addSprite_(spriteId);
            }
            if (element != null) {
                if (element instanceof GraphicNode) {
                    sprite.attachToNode((GraphicNode)element);
                } else if (element instanceof GraphicEdge) {
                    sprite.attachToEdge((GraphicEdge)element);
                }
            }
            if (value != null && !(value instanceof Boolean)) {
                this.positionSprite(sprite, value);
            }
        } else if (event == AbstractElement.AttributeChangeEvent.REMOVE) {
            if (element == null) {
                if (this.styleGroups.getSprite(spriteId) != null) {
                    this.removeSprite_(spriteId);
                }
            } else {
                GraphicSprite sprite = this.styleGroups.getSprite(spriteId);
                if (sprite != null) {
                    sprite.detach();
                }
            }
        }
    }

    public GraphicSprite addSprite(String id) {
        String prefix = String.format("ui.sprite.%s", id);
        logger.info(String.format("Added sprite %s.", id));
        this.setAttribute(prefix, 0, 0, 0);
        GraphicSprite s = this.styleGroups.getSprite(id);
        assert (s != null);
        return s;
    }

    protected GraphicSprite addSprite_(String id) {
        GraphicSprite s = new GraphicSprite(id, this);
        this.styleGroups.addElement(s);
        this.graphChanged = true;
        return s;
    }

    public void removeSprite(String id) {
        String prefix = String.format("ui.sprite.%s", id);
        this.removeAttribute(prefix);
    }

    protected GraphicSprite removeSprite_(String id) {
        GraphicSprite sprite = this.styleGroups.getSprite(id);
        if (sprite != null) {
            sprite.detach();
            this.styleGroups.removeElement(sprite);
            sprite.removed();
            this.graphChanged = true;
        }
        return sprite;
    }

    protected void positionSprite(GraphicSprite sprite, Object value) {
        if (value instanceof Object[]) {
            Object[] values2 = (Object[])value;
            if (values2.length == 4) {
                if (values2[0] instanceof Number && values2[1] instanceof Number && values2[2] instanceof Number && values2[3] instanceof StyleConstants.Units) {
                    sprite.setPosition(((Number)values2[0]).doubleValue(), ((Number)values2[1]).doubleValue(), ((Number)values2[2]).doubleValue(), (StyleConstants.Units)((Object)values2[3]));
                } else {
                    logger.warning("Cannot parse values[4] for sprite position.");
                }
            } else if (values2.length == 3) {
                if (values2[0] instanceof Number && values2[1] instanceof Number && values2[2] instanceof Number) {
                    sprite.setPosition(((Number)values2[0]).doubleValue(), ((Number)values2[1]).doubleValue(), ((Number)values2[2]).doubleValue(), StyleConstants.Units.GU);
                } else {
                    logger.warning("Cannot parse values[3] for sprite position.");
                }
            } else if (values2.length == 1) {
                if (values2[0] instanceof Number) {
                    sprite.setPosition(((Number)values2[0]).doubleValue());
                } else {
                    logger.warning("Sprite position percent is not a number.");
                }
            } else {
                logger.warning(String.format("Cannot transform value '%s' (length=%d) into a position%n", Arrays.toString(values2), values2.length));
            }
        } else if (value instanceof Number) {
            sprite.setPosition(((Number)value).doubleValue());
        } else if (value instanceof Value) {
            sprite.setPosition(((Value)value).value);
        } else if (value instanceof Values) {
            sprite.setPosition((Values)value);
        } else {
            if (value == null) {
                throw new RuntimeException("What do you expect with a null value ?");
            }
            logger.warning(String.format("Cannot place sprite with posiiton '%s' (instance of %s)%n", value, value.getClass().getName()));
        }
    }

    @Override
    public void clearAttributeSinks() {
        this.listeners.clearAttributeSinks();
    }

    @Override
    public void clearElementSinks() {
        this.listeners.clearElementSinks();
    }

    @Override
    public void clearSinks() {
        this.listeners.clearSinks();
    }

    @Override
    public Edge addEdge(String id, int index1, int index2) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge addEdge(String id, int fromIndex, int toIndex, boolean directed) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge addEdge(String id, Node node1, Node node2) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge addEdge(String id, Node from, Node to, boolean directed) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge getEdge(int index) throws IndexOutOfBoundsException {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Node getNode(int index) throws IndexOutOfBoundsException {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge removeEdge(int index) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge removeEdge(int fromIndex, int toIndex) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge removeEdge(Node node1, Node node2) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Edge removeEdge(Edge edge) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Node removeNode(int index) {
        throw new RuntimeException("not implemented !");
    }

    @Override
    public Node removeNode(Node node) {
        throw new RuntimeException("not implemented !");
    }

    public void replay() {
        this.attributeKeys().forEach(key -> this.listeners.sendGraphAttributeAdded(this.id, (String)key, this.getAttribute((String)key)));
        this.nodes().forEach(node -> {
            this.listeners.sendNodeAdded(this.id, node.getId());
            node.attributeKeys().forEach(key -> this.listeners.sendNodeAttributeAdded(this.id, node.getId(), (String)key, node.getAttribute((String)key)));
        });
        this.edges().forEach(edge -> {
            this.listeners.sendEdgeAdded(this.id, edge.getId(), edge.getSourceNode().getId(), edge.getTargetNode().getId(), edge.isDirected());
            edge.attributeKeys().forEach(key -> this.listeners.sendEdgeAttributeAdded(this.id, edge.getId(), (String)key, edge.getAttribute((String)key)));
        });
    }
}

