/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.graphstream.stream.binary.ByteEncoder;
import org.graphstream.stream.netstream.NetStreamConstants;
import org.graphstream.stream.netstream.NetStreamUtils;

public class NetStreamEncoder
implements ByteEncoder {
    private static final Logger LOGGER = Logger.getLogger(NetStreamEncoder.class.getName());
    protected final List<ByteEncoder.Transport> transportList;
    protected String sourceId;
    protected ByteBuffer sourceIdBuff;
    protected ByteBuffer streamBuffer;

    public NetStreamEncoder(ByteEncoder.Transport ... transports) {
        this("default", transports);
    }

    public NetStreamEncoder(String stream, ByteEncoder.Transport ... transports) {
        this.streamBuffer = NetStreamUtils.encodeString(stream);
        this.transportList = new LinkedList<ByteEncoder.Transport>();
        if (transports != null) {
            for (ByteEncoder.Transport transport : transports) {
                this.transportList.add(transport);
            }
        }
    }

    @Override
    public void addTransport(ByteEncoder.Transport transport) {
        this.transportList.add(transport);
    }

    @Override
    public void removeTransport(ByteEncoder.Transport transport) {
        this.transportList.remove(transport);
    }

    protected ByteBuffer getEncodedValue(Object in, int valueType) {
        ByteBuffer value = NetStreamUtils.encodeValue(in, valueType);
        if (value == null) {
            LOGGER.warning(String.format("unknown value type %d\n", valueType));
        }
        return value;
    }

    protected void doSend(ByteBuffer event) {
        for (ByteEncoder.Transport transport : this.transportList) {
            event.rewind();
            transport.send(event);
        }
    }

    protected ByteBuffer getAndPrepareBuffer(String sourceId, long timeId, int eventType, int messageSize) {
        if (!sourceId.equals(this.sourceId)) {
            this.sourceId = sourceId;
            this.sourceIdBuff = NetStreamUtils.encodeString(sourceId);
        }
        this.streamBuffer.rewind();
        this.sourceIdBuff.rewind();
        int size = 4 + this.streamBuffer.capacity() + 1 + this.sourceIdBuff.capacity() + NetStreamUtils.getVarintSize(timeId) + messageSize;
        ByteBuffer bb = ByteBuffer.allocate(size);
        bb.putInt(size).put(this.streamBuffer).put((byte)eventType).put(this.sourceIdBuff).put(NetStreamUtils.encodeUnsignedVarint(timeId));
        return bb;
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int valueType = NetStreamUtils.getType(value);
        ByteBuffer valueBuff = this.getEncodedValue(value, valueType);
        int innerSize = attrBuff.capacity() + 1 + valueBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_ADD_GRAPH_ATTR, innerSize);
        buff.put(attrBuff).put((byte)valueType).put(valueBuff);
        this.doSend(buff);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int oldValueType = NetStreamUtils.getType(oldValue);
        int newValueType = NetStreamUtils.getType(newValue);
        ByteBuffer oldValueBuff = this.getEncodedValue(oldValue, oldValueType);
        ByteBuffer newValueBuff = this.getEncodedValue(newValue, newValueType);
        int innerSize = attrBuff.capacity() + 1 + oldValueBuff.capacity() + 1 + newValueBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_CHG_GRAPH_ATTR, innerSize);
        buff.put(attrBuff).put((byte)oldValueType).put(oldValueBuff).put((byte)newValueType).put(newValueBuff);
        this.doSend(buff);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int innerSize = attrBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_DEL_GRAPH_ATTR, innerSize);
        buff.put(attrBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        ByteBuffer nodeBuff = NetStreamUtils.encodeString(nodeId);
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int valueType = NetStreamUtils.getType(value);
        ByteBuffer valueBuff = this.getEncodedValue(value, valueType);
        int innerSize = nodeBuff.capacity() + attrBuff.capacity() + 1 + valueBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_ADD_NODE_ATTR, innerSize);
        buff.put(nodeBuff).put(attrBuff).put((byte)valueType).put(valueBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        ByteBuffer nodeBuff = NetStreamUtils.encodeString(nodeId);
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int oldValueType = NetStreamUtils.getType(oldValue);
        int newValueType = NetStreamUtils.getType(newValue);
        ByteBuffer oldValueBuff = this.getEncodedValue(oldValue, oldValueType);
        ByteBuffer newValueBuff = this.getEncodedValue(newValue, newValueType);
        int innerSize = nodeBuff.capacity() + attrBuff.capacity() + 1 + oldValueBuff.capacity() + 1 + newValueBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_CHG_NODE_ATTR, innerSize);
        buff.put(nodeBuff).put(attrBuff).put((byte)oldValueType).put(oldValueBuff).put((byte)newValueType).put(newValueBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        ByteBuffer nodeBuff = NetStreamUtils.encodeString(nodeId);
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int innerSize = nodeBuff.capacity() + attrBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_DEL_NODE_ATTR, innerSize);
        buff.put(nodeBuff).put(attrBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        ByteBuffer edgeBuff = NetStreamUtils.encodeString(edgeId);
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int valueType = NetStreamUtils.getType(value);
        ByteBuffer valueBuff = this.getEncodedValue(value, valueType);
        int innerSize = edgeBuff.capacity() + attrBuff.capacity() + 1 + valueBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_ADD_EDGE_ATTR, innerSize);
        buff.put(edgeBuff).put(attrBuff).put((byte)valueType).put(valueBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        ByteBuffer edgeBuff = NetStreamUtils.encodeString(edgeId);
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int oldValueType = NetStreamUtils.getType(oldValue);
        int newValueType = NetStreamUtils.getType(newValue);
        ByteBuffer oldValueBuff = this.getEncodedValue(oldValue, oldValueType);
        ByteBuffer newValueBuff = this.getEncodedValue(newValue, newValueType);
        int innerSize = edgeBuff.capacity() + attrBuff.capacity() + 1 + oldValueBuff.capacity() + 1 + newValueBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_CHG_EDGE_ATTR, innerSize);
        buff.put(edgeBuff).put(attrBuff).put((byte)oldValueType).put(oldValueBuff).put((byte)newValueType).put(newValueBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        ByteBuffer edgeBuff = NetStreamUtils.encodeString(edgeId);
        ByteBuffer attrBuff = NetStreamUtils.encodeString(attribute);
        int innerSize = edgeBuff.capacity() + attrBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_DEL_EDGE_ATTR, innerSize);
        buff.put(edgeBuff).put(attrBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        ByteBuffer nodeBuff = NetStreamUtils.encodeString(nodeId);
        int innerSize = nodeBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_ADD_NODE, innerSize);
        buff.put(nodeBuff);
        this.doSend(buff);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        ByteBuffer nodeBuff = NetStreamUtils.encodeString(nodeId);
        int innerSize = nodeBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_DEL_NODE, innerSize);
        buff.put(nodeBuff);
        this.doSend(buff);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        ByteBuffer edgeBuff = NetStreamUtils.encodeString(edgeId);
        ByteBuffer fromNodeBuff = NetStreamUtils.encodeString(fromNodeId);
        ByteBuffer toNodeBuff = NetStreamUtils.encodeString(toNodeId);
        int innerSize = edgeBuff.capacity() + fromNodeBuff.capacity() + toNodeBuff.capacity() + 1;
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_ADD_EDGE, innerSize);
        buff.put(edgeBuff).put(fromNodeBuff).put(toNodeBuff).put((byte)(directed ? 1 : 0));
        this.doSend(buff);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        ByteBuffer edgeBuff = NetStreamUtils.encodeString(edgeId);
        int innerSize = edgeBuff.capacity();
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_DEL_EDGE, innerSize);
        buff.put(edgeBuff);
        this.doSend(buff);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_CLEARED, 0);
        this.doSend(buff);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        ByteBuffer buff = this.getAndPrepareBuffer(sourceId, timeId, NetStreamConstants.EVENT_STEP, 8);
        buff.putDouble(step);
        this.doSend(buff);
    }
}

