/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.dot;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSourceDOT;
import org.graphstream.stream.file.dot.DOTParserConstants;
import org.graphstream.stream.file.dot.DOTParserTokenManager;
import org.graphstream.util.parser.ParseException;
import org.graphstream.util.parser.Parser;
import org.graphstream.util.parser.SimpleCharStream;
import org.graphstream.util.parser.Token;

public class DOTParser
implements Parser,
DOTParserConstants {
    private FileSourceDOT dot;
    private String sourceId;
    private boolean directed;
    private boolean strict;
    private HashMap<String, Object> globalNodesAttributes;
    private HashMap<String, Object> globalEdgesAttributes;
    private HashSet<String> nodeAdded;
    public DOTParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[22];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public DOTParser(FileSourceDOT dot, InputStream stream) {
        this(stream);
        this.init(dot);
    }

    public DOTParser(FileSourceDOT dot, Reader stream) {
        this(stream);
        this.init(dot);
    }

    @Override
    public void close() throws IOException {
        this.jj_input_stream.close();
    }

    private void init(FileSourceDOT dot) {
        this.dot = dot;
        this.sourceId = String.format("<DOT stream %x>", System.nanoTime());
        this.globalNodesAttributes = new HashMap();
        this.globalEdgesAttributes = new HashMap();
        this.nodeAdded = new HashSet();
    }

    private void addNode(String nodeId, String[] port, HashMap<String, Object> attr) {
        block7: {
            block6: {
                if (!this.nodeAdded.contains(nodeId)) break block6;
                if (attr == null) break block7;
                for (String key : attr.keySet()) {
                    this.dot.sendAttributeChangedEvent(this.sourceId, nodeId, SourceBase.ElementType.NODE, key, AbstractElement.AttributeChangeEvent.ADD, null, attr.get(key));
                }
                break block7;
            }
            this.dot.sendNodeAdded(this.sourceId, nodeId);
            this.nodeAdded.add(nodeId);
            if (attr == null) {
                for (String key : this.globalNodesAttributes.keySet()) {
                    this.dot.sendAttributeChangedEvent(this.sourceId, nodeId, SourceBase.ElementType.NODE, key, AbstractElement.AttributeChangeEvent.ADD, null, this.globalNodesAttributes.get(key));
                }
            } else {
                for (String key : this.globalNodesAttributes.keySet()) {
                    if (attr.containsKey(key)) continue;
                    this.dot.sendAttributeChangedEvent(this.sourceId, nodeId, SourceBase.ElementType.NODE, key, AbstractElement.AttributeChangeEvent.ADD, null, this.globalNodesAttributes.get(key));
                }
                for (String key : attr.keySet()) {
                    this.dot.sendAttributeChangedEvent(this.sourceId, nodeId, SourceBase.ElementType.NODE, key, AbstractElement.AttributeChangeEvent.ADD, null, attr.get(key));
                }
            }
        }
    }

    private void addEdges(LinkedList<String> edges, HashMap<String, Object> attr) {
        int i;
        HashMap<String, Integer> hash = new HashMap<String, Integer>();
        String[] ids = new String[(edges.size() - 1) / 2];
        boolean[] directed = new boolean[(edges.size() - 1) / 2];
        int count = 0;
        for (i = 0; i < edges.size() - 1; i += 2) {
            String from = edges.get(i);
            String to = edges.get(i + 2);
            if (!this.nodeAdded.contains(from)) {
                this.addNode(from, null, null);
            }
            if (!this.nodeAdded.contains(to)) {
                this.addNode(to, null, null);
            }
            String edgeId = String.format("(%s;%s)", from, to);
            String rev = String.format("(%s;%s)", to, from);
            if (hash.containsKey(rev)) {
                directed[((Integer)hash.get((Object)rev)).intValue()] = false;
                continue;
            }
            hash.put(edgeId, count);
            ids[count] = edgeId;
            directed[count] = edges.get(i + 1).equals("->");
            ++count;
        }
        hash.clear();
        if (count == 1 && attr != null && attr.containsKey("id")) {
            ids[0] = attr.get("id").toString();
            attr.remove("id");
        }
        for (i = 0; i < count; ++i) {
            boolean addedEdge = false;
            String IDtoTry = ids[i];
            while (!addedEdge) {
                try {
                    this.dot.sendEdgeAdded(this.sourceId, ids[i], edges.get(i * 2), edges.get((i + 1) * 2), directed[i]);
                    addedEdge = true;
                }
                catch (IdAlreadyInUseException e) {
                    IDtoTry = IDtoTry + "'";
                }
            }
            if (attr == null) {
                for (String key : this.globalEdgesAttributes.keySet()) {
                    this.dot.sendAttributeChangedEvent(this.sourceId, ids[i], SourceBase.ElementType.EDGE, key, AbstractElement.AttributeChangeEvent.ADD, null, this.globalEdgesAttributes.get(key));
                }
                continue;
            }
            for (String key : this.globalEdgesAttributes.keySet()) {
                if (attr.containsKey(key)) continue;
                this.dot.sendAttributeChangedEvent(this.sourceId, ids[i], SourceBase.ElementType.EDGE, key, AbstractElement.AttributeChangeEvent.ADD, null, this.globalEdgesAttributes.get(key));
            }
            for (String key : attr.keySet()) {
                this.dot.sendAttributeChangedEvent(this.sourceId, ids[i], SourceBase.ElementType.EDGE, key, AbstractElement.AttributeChangeEvent.ADD, null, attr.get(key));
            }
        }
    }

    private void setGlobalAttributes(String who, HashMap<String, Object> attr) {
        if (who.equalsIgnoreCase("graph")) {
            for (String key : attr.keySet()) {
                this.dot.sendAttributeChangedEvent(this.sourceId, this.sourceId, SourceBase.ElementType.GRAPH, key, AbstractElement.AttributeChangeEvent.ADD, null, attr.get(key));
            }
        } else if (who.equalsIgnoreCase("node")) {
            this.globalNodesAttributes.putAll(attr);
        } else if (who.equalsIgnoreCase("edge")) {
            this.globalEdgesAttributes.putAll(attr);
        }
    }

    @Override
    public final void all() throws ParseException {
        this.graph();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 25: 
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.statement();
        }
        this.jj_consume_token(13);
    }

    @Override
    public final boolean next() throws ParseException {
        boolean hasMore = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                this.statement();
                hasMore = true;
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return hasMore;
    }

    @Override
    public final void open() throws ParseException {
        this.graph();
    }

    private final void graph() throws ParseException {
        this.directed = false;
        this.strict = false;
        this.globalNodesAttributes.clear();
        this.globalEdgesAttributes.clear();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                this.strict = true;
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                this.directed = true;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 25: 
            case 26: {
                this.sourceId = this.id();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(12);
    }

    private final void subgraph() throws ParseException {
        this.jj_consume_token(19);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 25: 
            case 26: {
                this.id();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        this.jj_consume_token(12);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 25: 
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            this.statement();
        }
        this.jj_consume_token(13);
    }

    private final String id() throws ParseException {
        String id;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                Token t = this.jj_consume_token(25);
                id = t.image.substring(1, t.image.length() - 1);
                break;
            }
            case 24: {
                Token t = this.jj_consume_token(24);
                id = t.image;
                break;
            }
            case 26: {
                Token t = this.jj_consume_token(26);
                id = t.image;
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return id;
    }

    private final void statement() throws ParseException {
        if (this.jj_2_1(3)) {
            this.edgeStatement();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 25: 
                case 26: {
                    this.nodeStatement();
                    break;
                }
                case 17: 
                case 20: 
                case 21: {
                    this.attributeStatement();
                    break;
                }
                case 19: {
                    this.subgraph();
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.jj_consume_token(27);
    }

    private final void nodeStatement() throws ParseException {
        HashMap<String, Object> attr = null;
        String[] port = null;
        String nodeId = this.id();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                port = this.port();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                attr = this.attributesList();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.addNode(nodeId, port, attr);
    }

    private final String compassPoint() throws ParseException {
        Token pt = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                pt = this.jj_consume_token(28);
                break;
            }
            case 29: {
                pt = this.jj_consume_token(29);
                break;
            }
            case 30: {
                pt = this.jj_consume_token(30);
                break;
            }
            case 31: {
                pt = this.jj_consume_token(31);
                break;
            }
            case 32: {
                pt = this.jj_consume_token(32);
                break;
            }
            case 33: {
                pt = this.jj_consume_token(33);
                break;
            }
            case 34: {
                pt = this.jj_consume_token(34);
                break;
            }
            case 35: {
                pt = this.jj_consume_token(35);
                break;
            }
            case 36: {
                pt = this.jj_consume_token(36);
                break;
            }
            case 37: {
                pt = this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return pt.image;
    }

    private final String[] port() throws ParseException {
        String[] p = new String[]{null, null};
        this.jj_consume_token(14);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 25: 
            case 26: {
                p[0] = this.id();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        p[1] = this.compassPoint();
                        break block0;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                p[1] = this.compassPoint();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return p;
    }

    private final void edgeStatement() throws ParseException {
        LinkedList<String> edges = new LinkedList<String>();
        HashMap<String, Object> attr = null;
        String id = this.id();
        edges.add(id);
        this.edgeRHS(edges);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                attr = this.attributesList();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        this.addEdges(edges, attr);
    }

    private final void edgeRHS(LinkedList<String> edges) throws ParseException {
        Token t = this.jj_consume_token(23);
        edges.add(t.image);
        String i = this.id();
        edges.add(i);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.edgeRHS(edges);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
    }

    private final void attributeStatement() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            case 20: {
                t = this.jj_consume_token(20);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        HashMap<String, Object> attr = this.attributesList();
        this.setGlobalAttributes(t.image, attr);
    }

    private final HashMap<String, Object> attributesList() throws ParseException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        block9: while (true) {
            this.jj_consume_token(10);
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 25: 
                case 26: {
                    this.attributeList(attributes);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 15: {
                                break;
                            }
                            default: {
                                this.jj_la1[17] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(15);
                        this.attributeList(attributes);
                    }
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            this.jj_consume_token(11);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    continue block9;
                }
            }
            break;
        }
        this.jj_la1[19] = this.jj_gen;
        return attributes;
    }

    private final void attributeList(HashMap<String, Object> attributes) throws ParseException {
        String key = this.id();
        Object val2 = Boolean.TRUE;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                if (this.jj_2_2(2)) {
                    Token t = this.jj_consume_token(24);
                    val2 = Double.parseDouble(t.image);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: 
                    case 25: 
                    case 26: {
                        val2 = this.id();
                        break block0;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        attributes.put(key, val2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3R_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_9()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_10()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_8() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_10() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_7() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_6();
    }

    private boolean jj_3R_9() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_5() {
        if (this.jj_3R_6()) {
            return true;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3_1() {
        return this.jj_3R_5();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{121241600, 121249793, 0x400000, 393216, 0x7000000, 0x7000000, 121241600, 0x7000000, 121241600, 16384, 1024, -268435456, 16384, -150994944, 1024, 0x800000, 0x320000, 32768, 0x7000000, 1024, 0x7000000, 65536};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0, 63, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public DOTParser(InputStream stream) {
        this(stream, null);
    }

    public DOTParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DOTParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DOTParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DOTParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DOTParser(DOTParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(DOTParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 22; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[38];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 22; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 38; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        DOTParser.jj_la1_init_0();
        DOTParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

