/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.dgs;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.util.parser.ParseException;
import org.graphstream.util.parser.Parser;

public class DGSParser
implements Parser {
    protected static final int BUFFER_SIZE = 4096;
    public static final int ARRAY_OPEN = 123;
    public static final int ARRAY_CLOSE = 125;
    public static final int MAP_OPEN = 91;
    public static final int MAP_CLOSE = 93;
    Reader reader;
    int line;
    int column;
    int bufferCapacity;
    int bufferPosition;
    char[] buffer;
    int[] pushback;
    int pushbackOffset;
    FileSourceDGS dgs;
    String sourceId;
    Token lastDirective;

    public DGSParser(FileSourceDGS dgs, Reader reader) {
        this.dgs = dgs;
        this.reader = reader;
        this.bufferCapacity = 0;
        this.buffer = new char[4096];
        this.pushback = new int[10];
        this.pushbackOffset = -1;
        this.sourceId = String.format("<DGS stream %x>", System.nanoTime());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void open() throws IOException, ParseException {
        this.header();
    }

    @Override
    public void all() throws IOException, ParseException {
        this.header();
        while (this.next()) {
        }
    }

    protected int nextChar() throws IOException {
        int c;
        if (this.pushbackOffset >= 0) {
            return this.pushback[this.pushbackOffset--];
        }
        if (this.bufferCapacity == 0 || this.bufferPosition >= this.bufferCapacity) {
            this.bufferCapacity = this.reader.read(this.buffer, 0, 4096);
            this.bufferPosition = 0;
        }
        if (this.bufferCapacity <= 0) {
            return -1;
        }
        if ((c = this.buffer[this.bufferPosition++]) == 13) {
            if (this.bufferPosition < this.bufferCapacity) {
                if (this.buffer[this.bufferPosition] == '\n') {
                    ++this.bufferPosition;
                }
            } else {
                c = this.nextChar();
                if (c != 10) {
                    this.pushback(c);
                }
            }
            c = 10;
        }
        if (c == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return c;
    }

    protected void pushback(int c) throws IOException {
        if (c < 0) {
            return;
        }
        if (this.pushbackOffset + 1 >= this.pushback.length) {
            throw new IOException("pushback buffer overflow");
        }
        this.pushback[++this.pushbackOffset] = c;
    }

    protected void skipLine() throws IOException {
        int c;
        while ((c = this.nextChar()) != 10 && c >= 0) {
        }
    }

    protected void skipWhitespaces() throws IOException {
        int c;
        while ((c = this.nextChar()) == 32 || c == 9) {
        }
        this.pushback(c);
    }

    protected void header() throws IOException, ParseException {
        int[] dgs = new int[6];
        for (int i = 0; i < 6; ++i) {
            dgs[i] = this.nextChar();
        }
        if (dgs[0] != 68 || dgs[1] != 71 || dgs[2] != 83) {
            throw this.parseException(String.format("bad magic header, 'DGS' expected, got '%c%c%c'", dgs[0], dgs[1], dgs[2]), new Object[0]);
        }
        if (dgs[3] != 48 || dgs[4] != 48 || dgs[5] < 48 || dgs[5] > 53) {
            throw this.parseException(String.format("bad version \"%c%c%c\"", dgs[0], dgs[1], dgs[2]), new Object[0]);
        }
        if (this.nextChar() != 10) {
            throw this.parseException("end-of-line is missing", new Object[0]);
        }
        this.skipLine();
    }

    @Override
    public boolean next() throws IOException, ParseException {
        int c;
        this.lastDirective = this.directive();
        switch (this.lastDirective) {
            case AN: {
                String nodeId = this.id();
                this.dgs.sendNodeAdded(this.sourceId, nodeId);
                this.attributes(SourceBase.ElementType.NODE, nodeId);
                break;
            }
            case CN: {
                String nodeId = this.id();
                this.attributes(SourceBase.ElementType.NODE, nodeId);
                break;
            }
            case DN: {
                String nodeId = this.id();
                this.dgs.sendNodeRemoved(this.sourceId, nodeId);
                break;
            }
            case AE: {
                String edgeId = this.id();
                String source = this.id();
                this.skipWhitespaces();
                c = this.nextChar();
                if (c != 60 && c != 62) {
                    this.pushback(c);
                }
                String target = this.id();
                switch (c) {
                    case 62: {
                        this.dgs.sendEdgeAdded(this.sourceId, edgeId, source, target, true);
                        break;
                    }
                    case 60: {
                        this.dgs.sendEdgeAdded(this.sourceId, edgeId, target, source, true);
                        break;
                    }
                    default: {
                        this.dgs.sendEdgeAdded(this.sourceId, edgeId, source, target, false);
                    }
                }
                this.attributes(SourceBase.ElementType.EDGE, edgeId);
                break;
            }
            case CE: {
                String edgeId = this.id();
                this.attributes(SourceBase.ElementType.EDGE, edgeId);
                break;
            }
            case DE: {
                String edgeId = this.id();
                this.dgs.sendEdgeRemoved(this.sourceId, edgeId);
                break;
            }
            case CG: {
                this.attributes(SourceBase.ElementType.GRAPH, null);
                break;
            }
            case ST: {
                double step = Double.valueOf(this.id());
                this.dgs.sendStepBegins(this.sourceId, step);
                break;
            }
            case CL: {
                this.dgs.sendGraphCleared(this.sourceId);
                break;
            }
            case TF: {
                break;
            }
            case EOF: {
                return false;
            }
        }
        this.skipWhitespaces();
        c = this.nextChar();
        if (c == 35) {
            this.skipLine();
            return true;
        }
        if (c < 0) {
            return false;
        }
        if (c != 10) {
            throw this.parseException("eol expected, got '%c'", c);
        }
        return true;
    }

    public boolean nextStep() throws IOException, ParseException {
        boolean r;
        Token next;
        do {
            r = this.next();
            next = this.directive();
            if (next == Token.EOF) continue;
            this.pushback(next.name().charAt(1));
            this.pushback(next.name().charAt(0));
        } while (next != Token.ST && next != Token.EOF);
        return r;
    }

    protected void attributes(SourceBase.ElementType type, String id) throws IOException, ParseException {
        int c;
        this.skipWhitespaces();
        while ((c = this.nextChar()) != 10 && c != 35 && c >= 0) {
            this.pushback(c);
            this.attribute(type, id);
            this.skipWhitespaces();
        }
        this.pushback(c);
    }

    protected void attribute(SourceBase.ElementType type, String elementId) throws IOException, ParseException {
        Object value = null;
        AbstractElement.AttributeChangeEvent ch = AbstractElement.AttributeChangeEvent.CHANGE;
        this.skipWhitespaces();
        int c = this.nextChar();
        if (c == 43) {
            ch = AbstractElement.AttributeChangeEvent.ADD;
        } else if (c == 45) {
            ch = AbstractElement.AttributeChangeEvent.REMOVE;
        } else {
            this.pushback(c);
        }
        String key = this.id();
        if (key == null) {
            throw this.parseException("attribute key expected", new Object[0]);
        }
        if (ch != AbstractElement.AttributeChangeEvent.REMOVE) {
            this.skipWhitespaces();
            c = this.nextChar();
            if (c == 61 || c == 58) {
                this.skipWhitespaces();
                value = this.value(true);
            } else {
                value = Boolean.TRUE;
                this.pushback(c);
            }
        }
        this.dgs.sendAttributeChangedEvent(this.sourceId, elementId, type, key, ch, null, value);
    }

    protected Object value(boolean array) throws IOException, ParseException {
        Object[] o;
        int c;
        LinkedList<Object[]> l = null;
        do {
            this.skipWhitespaces();
            c = this.nextChar();
            this.pushback(c);
            switch (c) {
                case 34: 
                case 39: {
                    o = this.string();
                    break;
                }
                case 35: {
                    o = this.color();
                    break;
                }
                case 123: {
                    this.nextChar();
                    this.skipWhitespaces();
                    o = this.value(true);
                    this.skipWhitespaces();
                    if (this.nextChar() != 125) {
                        throw this.parseException("'%c' expected", 125);
                    }
                    if (o.getClass().isArray()) break;
                    o = new Object[]{o};
                    break;
                }
                case 91: {
                    o = this.map();
                    break;
                }
                default: {
                    String word = this.id();
                    if (word == null) {
                        throw this.parseException("missing value", new Object[0]);
                    }
                    if (c >= 48 && c <= 57 || c == 45) {
                        try {
                            if (word.indexOf(46) > 0) {
                                o = Double.valueOf(word);
                                break;
                            }
                            try {
                                o = Integer.valueOf(word);
                            }
                            catch (NumberFormatException e) {
                                o = Long.valueOf(word);
                            }
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw this.parseException("invalid number format '%s'", word);
                        }
                    }
                    if (word.equalsIgnoreCase("true")) {
                        o = Boolean.TRUE;
                        break;
                    }
                    if (word.equalsIgnoreCase("false")) {
                        o = Boolean.FALSE;
                        break;
                    }
                    o = word;
                    break;
                }
            }
            c = this.nextChar();
            if (l == null && array && c == 44) {
                l = new LinkedList<Object[]>();
                l.add(o);
                continue;
            }
            if (l == null) continue;
            l.add(o);
        } while (array && c == 44);
        this.pushback(c);
        if (l == null) {
            return o;
        }
        return l.toArray();
    }

    protected Color color() throws IOException, ParseException {
        int a;
        StringBuilder hexa = new StringBuilder();
        int c = this.nextChar();
        if (c != 35) {
            throw this.parseException("'#' expected", new Object[0]);
        }
        for (int i = 0; i < 6; ++i) {
            c = this.nextChar();
            if (!(c >= 0 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                throw this.parseException("hexadecimal value expected", new Object[0]);
            }
            hexa.appendCodePoint(c);
        }
        int r = Integer.parseInt(hexa.substring(0, 2), 16);
        int g = Integer.parseInt(hexa.substring(2, 4), 16);
        int b = Integer.parseInt(hexa.substring(4, 6), 16);
        c = this.nextChar();
        if (c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70) {
            hexa.appendCodePoint(c);
            c = this.nextChar();
            if (!(c >= 0 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                throw this.parseException("hexadecimal value expected", new Object[0]);
            }
            hexa.appendCodePoint(c);
            a = Integer.parseInt(hexa.substring(6, 8), 16);
        } else {
            a = 255;
            this.pushback(c);
        }
        return new Color(r, g, b, a);
    }

    protected Object array() throws IOException, ParseException {
        LinkedList<Object> array = new LinkedList<Object>();
        int c = this.nextChar();
        if (c != 123) {
            throw this.parseException("'%c' expected", 123);
        }
        this.skipWhitespaces();
        c = this.nextChar();
        while (c != 125) {
            this.pushback(c);
            array.add(this.value(false));
            this.skipWhitespaces();
            c = this.nextChar();
            if (c != 125 && c != 44) {
                throw this.parseException("'%c' or ',' expected, got '%c'", 125, c);
            }
            if (c != 44) continue;
            this.skipWhitespaces();
            c = this.nextChar();
        }
        if (c != 125) {
            throw this.parseException("'%c' expected", 125);
        }
        return array.toArray();
    }

    protected Object map() throws IOException, ParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int c = this.nextChar();
        if (c != 91) {
            throw this.parseException("'%c' expected", 91);
        }
        c = this.nextChar();
        while (c != 93) {
            Object value;
            this.pushback(c);
            String key = this.id();
            if (key == null) {
                throw this.parseException("id expected here, '%c'", c);
            }
            this.skipWhitespaces();
            c = this.nextChar();
            if (c == 61 || c == 58) {
                this.skipWhitespaces();
                value = this.value(false);
            } else {
                value = Boolean.TRUE;
                this.pushback(c);
            }
            map.put(key, value);
            this.skipWhitespaces();
            c = this.nextChar();
            if (c != 93 && c != 44) {
                throw this.parseException("'%c' or ',' expected, got '%c'", 93, c);
            }
            if (c != 44) continue;
            this.skipWhitespaces();
            c = this.nextChar();
        }
        if (c != 93) {
            throw this.parseException("'%c' expected", 93);
        }
        return map;
    }

    protected Token directive() throws IOException, ParseException {
        int c1;
        do {
            if ((c1 = this.nextChar()) == 35) {
                this.skipLine();
            }
            if (c1 >= 0) continue;
            return Token.EOF;
        } while (c1 == 35 || c1 == 10);
        int c2 = this.nextChar();
        if (c1 >= 65 && c1 <= 90) {
            c1 += 32;
        }
        if (c2 >= 65 && c2 <= 90) {
            c2 += 32;
        }
        switch (c1) {
            case 97: {
                if (c2 == 110) {
                    return Token.AN;
                }
                if (c2 != 101) break;
                return Token.AE;
            }
            case 99: {
                switch (c2) {
                    case 110: {
                        return Token.CN;
                    }
                    case 101: {
                        return Token.CE;
                    }
                    case 103: {
                        return Token.CG;
                    }
                    case 108: {
                        return Token.CL;
                    }
                }
                break;
            }
            case 100: {
                if (c2 == 110) {
                    return Token.DN;
                }
                if (c2 != 101) break;
                return Token.DE;
            }
            case 115: {
                if (c2 != 116) break;
                return Token.ST;
            }
            case 116: {
                if (c1 != 102) break;
                return Token.TF;
            }
        }
        throw this.parseException("unknown directive '%c%c'", c1, c2);
    }

    protected String string() throws IOException, ParseException {
        boolean slash = false;
        StringBuilder builder = new StringBuilder();
        int c = this.nextChar();
        if (c != 34 && c != 39) {
            throw this.parseException("string expected", new Object[0]);
        }
        int s = c;
        while ((c = this.nextChar()) != s || slash) {
            if (slash && c != s) {
                builder.append("\\");
            }
            if (slash = c == 92) continue;
            if (!Character.isValidCodePoint(c)) {
                throw this.parseException("invalid code-point 0x%X", c);
            }
            builder.appendCodePoint(c);
        }
        return builder.toString();
    }

    protected String id() throws IOException, ParseException {
        StringBuilder builder = new StringBuilder();
        this.skipWhitespaces();
        int c = this.nextChar();
        this.pushback(c);
        if (c == 34 || c == 39) {
            return this.string();
        }
        boolean stop = false;
        while (!stop) {
            c = this.nextChar();
            switch (Character.getType(c)) {
                case 1: 
                case 2: 
                case 9: {
                    break;
                }
                case 20: {
                    if (c == 45) break;
                    stop = true;
                    break;
                }
                case 25: {
                    if (c == 43) break;
                    stop = true;
                    break;
                }
                case 23: {
                    if (c == 95) break;
                    stop = true;
                    break;
                }
                case 24: {
                    if (c == 46) break;
                    stop = true;
                    break;
                }
                default: {
                    stop = true;
                }
            }
            if (stop) continue;
            builder.appendCodePoint(c);
        }
        this.pushback(c);
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    protected ParseException parseException(String message, Object ... args2) {
        return new ParseException(String.format(String.format("parse error at (%d;%d) : %s", this.line, this.column, message), args2));
    }

    static enum Token {
        AN,
        CN,
        DN,
        AE,
        CE,
        DE,
        CG,
        ST,
        CL,
        TF,
        EOF;

    }
}

