/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.graphstream.stream.file.FileSinkBase;

public class FileSinkGML
extends FileSinkBase {
    protected PrintWriter out;
    protected String nodeToFinish = null;
    protected String edgeToFinish = null;
    Pattern forbiddenKeyChars = Pattern.compile(".*[^a-zA-Z0-9-_.].*");

    @Override
    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.out.printf("graph [%n", new Object[0]);
    }

    @Override
    protected void outputEndOfFile() throws IOException {
        this.ensureToFinish();
        this.out.printf("]%n", new Object[0]);
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.ensureToFinish();
        String val2 = this.valueToString(value);
        attribute = this.keyToString(attribute);
        if (val2 != null) {
            this.out.printf("\t%s %s%n", attribute, val2);
        }
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.ensureToFinish();
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.ensureToFinish();
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        if (this.nodeToFinish != null && this.nodeToFinish.equals(nodeId)) {
            String val2 = this.valueToString(value);
            attribute = this.keyToString(attribute);
            if (val2 != null) {
                this.out.printf("\t\t%s %s%n", attribute, val2);
            }
        } else {
            this.ensureToFinish();
        }
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (this.edgeToFinish != null) {
            this.ensureToFinish();
        }
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        if (this.edgeToFinish != null) {
            this.ensureToFinish();
        }
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        if (this.edgeToFinish != null && this.edgeToFinish.equals(edgeId)) {
            String val2 = this.valueToString(value);
            attribute = this.keyToString(attribute);
            if (val2 != null) {
                this.out.printf("\t\t%s %s%n", attribute, val2);
            }
        } else {
            this.ensureToFinish();
        }
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (this.nodeToFinish != null) {
            this.ensureToFinish();
        }
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        if (this.nodeToFinish != null) {
            this.ensureToFinish();
        }
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.ensureToFinish();
        this.out.printf("\tnode [%n", new Object[0]);
        this.out.printf("\t\tid \"%s\"%n", nodeId);
        this.nodeToFinish = nodeId;
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.ensureToFinish();
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.ensureToFinish();
        this.out.printf("\tedge [%n", new Object[0]);
        this.out.printf("\t\tid \"%s\"%n", edgeId);
        this.out.printf("\t\tsource \"%s\"%n", fromNodeId);
        this.out.printf("\t\ttarget \"%s\"%n", toNodeId);
        this.edgeToFinish = edgeId;
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.ensureToFinish();
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
    }

    protected String keyToString(String key) {
        if (this.forbiddenKeyChars.matcher(key).matches()) {
            return "\"" + key.replace("\"", "\\\"") + "\"";
        }
        return key;
    }

    protected String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            double val2 = ((Number)value).doubleValue();
            if (val2 - (double)((int)val2) == 0.0) {
                return String.format(Locale.US, "%d", (int)val2);
            }
            return String.format(Locale.US, "%f", val2);
        }
        return String.format("\"%s\"", value.toString().replaceAll("\n|\r|\"", " "));
    }

    protected void ensureToFinish() {
        assert (this.nodeToFinish != null && this.edgeToFinish == null || this.nodeToFinish == null && this.edgeToFinish != null || this.nodeToFinish == null && this.edgeToFinish == null);
        if (this.nodeToFinish != null || this.edgeToFinish != null) {
            this.out.printf("\t]%n", new Object[0]);
            this.nodeToFinish = null;
            this.edgeToFinish = null;
        }
    }
}

