/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.randomWalk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.StringJoiner;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.algorithm.randomWalk.Entity;
import org.graphstream.algorithm.randomWalk.TabuEntity;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.SinkAdapter;

public class RandomWalk
extends SinkAdapter
implements DynamicAlgorithm {
    protected Context context = new Context();
    protected String entityClass = TabuEntity.class.getName();
    protected ArrayList<Entity> entities = new ArrayList();
    protected long randomSeed;
    protected int entityCount = 100;
    protected double evaporation = 1.0;
    protected boolean doNodes = true;
    protected boolean doEdges = true;

    public RandomWalk() {
        this(System.currentTimeMillis());
    }

    public RandomWalk(long randomSeed) {
        this.randomSeed = randomSeed;
        this.context.random = new Random(randomSeed);
    }

    public String getPassesAttribute() {
        return this.context.passesAttribute;
    }

    @Parameter
    public void setEntityClass(String name) {
        this.entityClass = name == null ? TabuEntity.class.getName() : name;
    }

    @Parameter
    public void setEntityMemory(int size) {
        if (size < 0) {
            size = 0;
        }
        this.context.entityMemory = size;
    }

    @Parameter
    public void setEvaporation(double evaporation) {
        if (evaporation >= 0.0 && evaporation < 1.0) {
            this.evaporation = evaporation;
        }
    }

    public double getEvaporation() {
        return this.evaporation;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public int getEntityCount() {
        return this.entities.size();
    }

    public int getJumpCount() {
        return this.context.jumpCount;
    }

    public int getWaitCount() {
        return this.context.waitCount;
    }

    public int getGoCount() {
        return this.context.goCount;
    }

    public double getJumpRatio() {
        return (double)this.context.jumpCount / (double)this.entities.size();
    }

    @Parameter
    public void setWeightAttribute(String name) {
        this.context.weightAttribute = name;
    }

    @Parameter
    public void setPassesAttribute(String name) {
        if (this.context.graph != null) {
            this.context.graph.edges().forEach(e -> {
                e.setAttribute(name, e.getNumber(this.context.passesAttribute));
                e.removeAttribute(this.context.passesAttribute);
            });
            this.context.graph.forEach(n -> {
                n.setAttribute(name, n.getNumber(this.context.passesAttribute));
                n.removeAttribute(this.context.passesAttribute);
            });
        }
        this.context.passesAttribute = name;
    }

    public double getPasses(Edge edge) {
        return edge.getNumber(this.context.passesAttribute);
    }

    public double getPasses(Node node) {
        return node.getNumber(this.context.passesAttribute);
    }

    @Parameter
    public void setEntityCount(int entityCount) {
        this.entityCount = entityCount;
    }

    public void computeEdgesPasses(boolean on) {
        this.doEdges = on;
    }

    public void computeNodePasses(boolean on) {
        this.doNodes = on;
    }

    public Entity createEntity() {
        try {
            Object o = Class.forName(this.entityClass).newInstance();
            if (o instanceof Entity) {
                Entity e = (Entity)o;
                e.init(this.context, Toolkit.randomNode(this.context.graph, this.context.random));
                return e;
            }
            System.err.printf("Object %s  pointed at by class name '%s' does not implement Entity.%n", o.getClass().getName(), this.entityClass);
        }
        catch (Exception e) {
            System.err.printf("Error: %s%n", e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void init(Graph graph) {
        if (this.context.graph != null) {
            throw new RuntimeException("cannot begin a random walk if the previous one was not finished, use end().");
        }
        this.context.graph = graph;
        this.entities.clear();
        for (int i = 0; i < this.entityCount; ++i) {
            this.entities.add(this.createEntity());
        }
        this.equipGraph();
        graph.addElementSink(this);
    }

    @Override
    public void compute() {
        this.context.jumpCount = 0;
        this.context.goCount = 0;
        this.context.waitCount = 0;
        this.entities.forEach(entity -> entity.step());
        if (this.evaporation < 1.0) {
            this.evaporate();
        }
    }

    protected void evaporate() {
        this.context.graph.edges().forEach(edge -> edge.setAttribute(this.context.passesAttribute, edge.getNumber(this.context.passesAttribute) * this.evaporation));
        this.context.graph.nodes().forEach(node -> node.setAttribute(this.context.passesAttribute, node.getNumber(this.context.passesAttribute) * this.evaporation));
    }

    @Override
    public void terminate() {
        this.entities.clear();
        this.context.graph.removeElementSink(this);
        this.context.graph = null;
    }

    protected void equipGraph() {
        this.context.graph.edges().forEach(e -> e.setAttribute(this.context.passesAttribute, 0.0));
        this.context.graph.nodes().forEach(n -> n.setAttribute(this.context.passesAttribute, 0.0));
    }

    public ArrayList<Edge> findTheMostUsedEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>(this.context.graph.getEdgeCount());
        this.context.graph.edges().forEach(e -> edges.add((Edge)e));
        Collections.sort(edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                int n1 = (int)e1.getNumber(RandomWalk.this.context.passesAttribute);
                int n2 = (int)e2.getNumber(RandomWalk.this.context.passesAttribute);
                return n1 - n2;
            }
        });
        return edges;
    }

    public ArrayList<Node> findTheMostUsedNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.context.graph.getNodeCount());
        this.context.graph.nodes().forEach(n -> nodes.add((Node)n));
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node e1, Node e2) {
                int n1 = (int)e1.getNumber(RandomWalk.this.context.passesAttribute);
                int n2 = (int)e2.getNumber(RandomWalk.this.context.passesAttribute);
                return n1 - n2;
            }
        });
        return nodes;
    }

    @Override
    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        Edge edge = this.context.graph.getEdge(edgeId);
        if (edge != null) {
            edge.setAttribute(this.context.passesAttribute, 0.0);
        }
    }

    @Override
    public void nodeAdded(String graphId, long timeId, String nodeId) {
        Node node = this.context.graph.getNode(nodeId);
        node.setAttribute(this.context.passesAttribute, 0.0);
    }

    @Result
    public String defaultResult() {
        StringJoiner sj = new StringJoiner(" | ", "====== Random Walk ====== \n", "");
        this.context.graph.edges().forEach(e -> sj.add("Edge " + e.getId() + " counts " + this.getPasses((Edge)e)));
        return sj.toString();
    }

    public class Context {
        protected Graph graph;
        protected String passesAttribute = "passes";
        protected String weightAttribute = null;
        protected Random random;
        protected int entityMemory = 0;
        protected int jumpCount = 0;
        protected int goCount = 0;
        protected int waitCount = 0;

        public String getPassesAttribute() {
            return this.passesAttribute;
        }

        public String getWeightAttribute() {
            return this.weightAttribute;
        }

        public Random getRandom() {
            return this.random;
        }

        public int getEntityMemory() {
            return this.entityMemory;
        }
    }
}

