/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import org.graphstream.algorithm.generator.Generator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.SourceBase;

public abstract class BaseGenerator
extends SourceBase
implements Generator {
    protected boolean directed = false;
    protected boolean randomlyDirected = false;
    protected Map<String, Function<Random, ?>> nodeAttributes = new HashMap();
    protected Map<String, Function<Random, ?>> edgeAttributes = new HashMap();
    protected Random random = new Random();
    protected boolean addNodeLabels = false;
    protected boolean addEdgeLabels = false;
    private boolean useInternalGraph;
    protected Graph internalGraph;
    private static volatile int generatorId;

    public BaseGenerator() {
        this(false, false);
    }

    public BaseGenerator(boolean directed, boolean randomlyDirectedEdges) {
        super(String.format("generator-%08x", generatorId++));
        this.setDirectedEdges(directed, randomlyDirectedEdges);
    }

    public BaseGenerator(boolean directed, boolean randomlyDirectedEdges, String nodeAttribute, String edgeAttribute) {
        this(directed, randomlyDirectedEdges);
        this.addNodeAttribute(nodeAttribute);
        this.addEdgeAttribute(edgeAttribute);
    }

    @Override
    public void end() {
        this.clearKeptData();
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    public void addNodeLabels(boolean on) {
        this.addNodeLabels = on;
    }

    public void addEdgeLabels(boolean on) {
        this.addEdgeLabels = on;
    }

    public void setDirectedEdges(boolean directed, boolean randomly) {
        this.directed = directed;
        if (directed && randomly) {
            this.randomlyDirected = randomly;
        }
    }

    public void addNodeAttribute(String name, Function<Random, ?> factory) {
        this.nodeAttributes.put(name, factory);
    }

    public void addNodeAttribute(String name, double min, double max) {
        this.addNodeAttribute(name, random -> min + (max - min) * random.nextDouble());
    }

    public void addNodeAttribute(String name) {
        this.addNodeAttribute(name, 0.0, 1.0);
    }

    public void removeNodeAttribute(String name) {
        this.nodeAttributes.remove(name);
    }

    public void addEdgeAttribute(String name, Function<Random, ?> factory) {
        this.edgeAttributes.put(name, factory);
    }

    public void addEdgeAttribute(String name, double min, double max) {
        this.addEdgeAttribute(name, random -> min + (max - min) * random.nextDouble());
    }

    public void addEdgeAttribute(String name) {
        this.addEdgeAttribute(name, 0.0, 1.0);
    }

    public void removeEdgeAttribute(String name) {
        this.edgeAttributes.remove(name);
    }

    public void setUseInternalGraph(boolean on) {
        this.useInternalGraph = on;
        if (!on && this.internalGraph != null) {
            this.internalGraph.clear();
            this.internalGraph = null;
        }
        if (on && this.internalGraph == null) {
            this.internalGraph = new AdjacencyListGraph(this.getClass().getName() + "-internal_graph");
            this.internalGraph.setStrict(false);
        }
    }

    public boolean isUsingInternalGraph() {
        return this.useInternalGraph;
    }

    protected void addNode(String id, double x, double y) {
        this.addNode(id);
        this.sendNodeAttributeAdded(this.sourceId, id, "xy", new Double[]{new Double(x), new Double(y)});
        if (this.useInternalGraph) {
            this.internalGraph.getNode(id).setAttribute("xy", new Object[]{new Double[]{new Double(x), new Double(y)}});
        }
    }

    protected void addNode(String id) {
        this.sendNodeAdded(this.sourceId, id);
        if (this.addNodeLabels) {
            this.sendNodeAttributeAdded(this.sourceId, id, "label", id);
        }
        if (this.useInternalGraph) {
            this.internalGraph.addNode(id);
        }
        this.nodeAttributes.forEach((attribute, factory) -> {
            Object value = factory.apply(this.random);
            this.sendNodeAttributeAdded(this.sourceId, id, (String)attribute, value);
            if (this.useInternalGraph) {
                this.internalGraph.getNode(id).setAttribute((String)attribute, value);
            }
        });
    }

    protected void delNode(String id) {
        if (this.useInternalGraph) {
            this.internalGraph.removeNode(id);
        }
        this.sendNodeRemoved(this.sourceId, id);
    }

    protected void addEdge(String id, String from, String to) {
        if (this.directed && this.randomlyDirected && this.random.nextFloat() > 0.5f) {
            String tmp = from;
            from = to;
            to = tmp;
        }
        if (id == null) {
            id = from + "_" + to;
        }
        this.sendEdgeAdded(this.sourceId, id, from, to, this.directed);
        if (this.useInternalGraph) {
            this.internalGraph.addEdge(id, from, to, this.directed);
        }
        if (this.addEdgeLabels) {
            this.sendEdgeAttributeAdded(this.sourceId, id, "label", id);
        }
        String idFinal = id;
        this.edgeAttributes.forEach((attribute, factory) -> {
            Object value = factory.apply(this.random);
            this.sendEdgeAttributeAdded(this.sourceId, idFinal, (String)attribute, value);
            if (this.useInternalGraph) {
                this.internalGraph.getEdge(idFinal).setAttribute((String)attribute, value);
            }
        });
    }

    protected void delEdge(String edgeId) {
        this.sendEdgeRemoved(this.sourceId, edgeId);
        if (this.useInternalGraph) {
            this.internalGraph.removeEdge(edgeId);
        }
    }

    protected void clearKeptData() {
        if (this.useInternalGraph) {
            this.internalGraph.clear();
        }
    }
}

