/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.flow;

import java.util.LinkedList;
import java.util.stream.Collectors;
import org.graphstream.algorithm.flow.FlowAlgorithmBase;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.Node;

public class FordFulkersonAlgorithm
extends FlowAlgorithmBase {
    @Override
    public void compute() {
        Node source = this.flowGraph.getNode(this.sourceId);
        Node sink = this.flowGraph.getNode(this.sinkId);
        if (source == null) {
            throw new ElementNotFoundException("node \"%s\"", this.sourceId);
        }
        if (sink == null) {
            throw new ElementNotFoundException("node \"%s\"", this.sinkId);
        }
        this.checkArrays();
        this.loadCapacitiesFromAttribute();
        for (int i = 0; i < this.flowGraph.getEdgeCount(); ++i) {
            Edge e = this.flowGraph.getEdge(i);
            this.setFlow(e.getNode0(), e.getNode1(), 0.0);
            this.setFlow(e.getNode1(), e.getNode0(), 0.0);
        }
        LinkedList<Node> path = new LinkedList<Node>();
        while (true) {
            double d;
            double minCf = this.findPath(path, source, sink);
            if (!(d > 0.0)) break;
            for (int i = 1; i < path.size(); ++i) {
                Node u = path.get(i - 1);
                Node v = path.get(i);
                this.setFlow(u, v, this.getFlow(u, v) + minCf);
                this.setFlow(v, u, this.getFlow(v, u) - minCf);
            }
            path.clear();
        }
        double flow = 0.0;
        for (int i = 0; i < source.getDegree(); ++i) {
            flow += this.getFlow(source, source.getEdge(i).getOpposite(source));
        }
        this.maximumFlow = flow;
    }

    protected double findPath(LinkedList<Node> path, Node source, Node target) {
        path.addLast(source);
        if (source == target) {
            return Double.MAX_VALUE;
        }
        for (int i = 0; i < source.getDegree(); ++i) {
            double d;
            Edge e = source.getEdge(i);
            Node o = e.getOpposite(source);
            if (!(this.getCapacity(source, o) - this.getFlow(source, o) > 0.0) || path.contains(o)) continue;
            double minCf = this.findPath(path, o, target);
            if (!(d > 0.0)) continue;
            return Math.min(minCf, this.getCapacity(source, o) - this.getFlow(source, o));
        }
        path.removeLast();
        return 0.0;
    }

    @Result
    public String defaultResult() {
        LinkedList path = this.flowGraph.nodes().collect(Collectors.toCollection(LinkedList::new));
        Node s = this.flowGraph.getNode(this.sourceId);
        Node t = this.flowGraph.getNode(this.sinkId);
        return this.findPath(path, s, t) + "";
    }
}

