/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.flow;

import java.util.List;
import org.graphstream.algorithm.flow.FlowAlgorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public abstract class FlowAlgorithmBase
implements FlowAlgorithm {
    protected Graph flowGraph = null;
    protected int n;
    protected double[] capacities;
    protected double[] flows;
    protected String sourceId;
    protected String sinkId;
    protected double maximumFlow;
    protected String capacityAttribute = null;

    protected FlowAlgorithmBase() {
    }

    protected void checkArrays() {
        this.n = this.flowGraph.getEdgeCount();
        if (this.capacities == null || this.capacities.length < 2 * this.n) {
            this.capacities = new double[2 * this.n];
            this.flows = new double[2 * this.n];
        }
    }

    @Override
    public String getFlowSourceId() {
        return this.sourceId;
    }

    @Override
    public String getFlowSinkId() {
        return this.sinkId;
    }

    @Override
    public void init(Graph graph) {
        this.flowGraph = graph;
        this.checkArrays();
    }

    @Override
    public void init(Graph g, String sourceId, String sinkId) {
        this.init(g);
        this.sourceId = sourceId;
        this.sinkId = sinkId;
    }

    @Parameter(value=true)
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Parameter(value=true)
    public void setSinkId(String sinkId) {
        this.sinkId = sinkId;
    }

    @Override
    public double getMaximumFlow() {
        return this.maximumFlow;
    }

    public double getFlow(int uIndex, int vIndex) {
        Node u = this.flowGraph.getNode(uIndex);
        Node v = this.flowGraph.getNode(vIndex);
        return this.getFlow(u, v);
    }

    public double getFlow(String uId, String vId) {
        Node u = this.flowGraph.getNode(uId);
        Node v = this.flowGraph.getNode(vId);
        return this.getFlow(u, v);
    }

    @Override
    public double getFlow(Node u, Node v) {
        Edge e = u.getEdgeBetween(v);
        if (e.getSourceNode() == u) {
            return this.flows[e.getIndex()];
        }
        return this.flows[e.getIndex() + this.n];
    }

    public void setFlow(int uIndex, int vIndex, double flow) {
        Node u = this.flowGraph.getNode(uIndex);
        Node v = this.flowGraph.getNode(vIndex);
        this.setFlow(u, v, flow);
    }

    public void setFlow(String uId, String vId, double flow) {
        Node u = this.flowGraph.getNode(uId);
        Node v = this.flowGraph.getNode(vId);
        this.setFlow(u, v, flow);
    }

    @Override
    public void setFlow(Node u, Node v, double flow) {
        Edge e = u.getEdgeBetween(v);
        if (e.getSourceNode() == u) {
            this.flows[e.getIndex()] = flow;
        } else {
            this.flows[e.getIndex() + this.n] = flow;
        }
    }

    public double getCapacity(int uIndex, int vIndex) {
        Node u = this.flowGraph.getNode(uIndex);
        Node v = this.flowGraph.getNode(vIndex);
        return this.getCapacity(u, v);
    }

    public double getCapacity(String uId, String vId) {
        Node u = this.flowGraph.getNode(uId);
        Node v = this.flowGraph.getNode(vId);
        return this.getCapacity(u, v);
    }

    @Override
    public double getCapacity(Node u, Node v) {
        Edge e = u.getEdgeBetween(v);
        if (e == null) {
            System.err.printf("no edge between %s and %s\n", u.getId(), v.getId());
        }
        if (e.getSourceNode() == u) {
            return this.capacities[e.getIndex()];
        }
        return this.capacities[e.getIndex() + this.n];
    }

    public void setCapacity(int uIndex, int vIndex, double capacity) {
        Node u = this.flowGraph.getNode(uIndex);
        Node v = this.flowGraph.getNode(vIndex);
        this.setCapacity(u, v, capacity);
    }

    public void setCapacity(String uId, String vId, double capacity) {
        Node u = this.flowGraph.getNode(uId);
        Node v = this.flowGraph.getNode(vId);
        this.setCapacity(u, v, capacity);
    }

    @Override
    public void setCapacity(Node u, Node v, double capacity) {
        Edge e = u.getEdgeBetween(v);
        if (e.getSourceNode() == u) {
            this.capacities[e.getIndex()] = capacity;
        } else {
            this.capacities[e.getIndex() + this.n] = capacity;
        }
    }

    @Override
    @Parameter
    public void setCapacityAttribute(String attribute) {
        this.capacityAttribute = attribute;
    }

    @Override
    public String getCapacityAttribute() {
        return this.capacityAttribute;
    }

    @Parameter
    public void setAllCapacities(double value) {
        for (int i = 0; i < 2 * this.n; ++i) {
            this.capacities[i] = value;
        }
    }

    protected void loadCapacitiesFromAttribute() {
        if (this.capacityAttribute == null) {
            return;
        }
        for (int i = 0; i < this.n; ++i) {
            this.capacities[i] = 0.0;
            this.capacities[i + this.n] = 0.0;
            Edge e = this.flowGraph.getEdge(i);
            if (e.hasNumber(this.capacityAttribute)) {
                this.capacities[i] = e.getNumber(this.capacityAttribute);
                continue;
            }
            if (e.hasVector(this.capacityAttribute)) {
                List<? extends Number> capVect = this.flowGraph.getEdge(i).getVector(this.capacityAttribute);
                if (capVect.size() > 0) {
                    this.capacities[i] = capVect.get(0).doubleValue();
                }
                if (capVect.size() <= 1) continue;
                this.capacities[i + this.n] = capVect.get(1).doubleValue();
                continue;
            }
            if (e.hasArray(this.capacityAttribute)) {
                Object[] capArray = e.getArray(this.capacityAttribute);
                if (capArray.length > 0) {
                    this.capacities[i] = ((Number)capArray[0]).doubleValue();
                }
                if (capArray.length <= 1) continue;
                this.capacities[i + this.n] = ((Number)capArray[1]).doubleValue();
                continue;
            }
            if (!e.hasAttribute(this.capacityAttribute)) continue;
            System.err.printf("unknown capacity type \"%s\"\n", e.getAttribute(this.capacityAttribute).getClass());
        }
    }
}

