/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;

public class TopologicalSortKahn
implements Algorithm {
    private Graph graph;
    private List<Node> sortedNodes;
    private Set<Node> sourceNodes;

    @Override
    public void init(Graph theGraph) {
        this.graph = this.getCopyOfGraph(theGraph);
        this.sortedNodes = new ArrayList<Node>();
        this.sourceNodes = this.calculateSourceNodes();
    }

    private Graph getCopyOfGraph(Graph theGraph) {
        SingleGraph aGraphCopy = new SingleGraph("TopoSortKahn");
        theGraph.nodes().forEach(aNode -> aGraphCopy.addNode(aNode.getId()));
        theGraph.edges().forEach(anEdge -> {
            if (!anEdge.isDirected()) {
                this.throwException();
            }
            aGraphCopy.addEdge(anEdge.getId(), anEdge.getSourceNode().getId(), anEdge.getTargetNode().getId(), true);
        });
        return aGraphCopy;
    }

    @Override
    public void compute() {
        while (!this.sourceNodes.isEmpty()) {
            Node aSourceNode = this.sourceNodes.iterator().next();
            this.sourceNodes.remove(aSourceNode);
            this.sortedNodes.add(aSourceNode);
            aSourceNode.leavingEdges().forEach(anEdge -> this.removeEdge(aSourceNode));
        }
        if (this.hasCycle()) {
            this.throwException();
        }
        System.out.println("TopologicalSortedNodes:" + Arrays.toString(this.sortedNodes.toArray()));
    }

    private boolean hasCycle() {
        return this.graph.nodes().anyMatch(aNode -> aNode.enteringEdges().count() != 0L);
    }

    private void removeEdge(Node aSourceNode) {
        Edge aLeavingEdge = aSourceNode.getLeavingEdge(0);
        Node aTargetNode = aLeavingEdge.getTargetNode();
        this.graph.removeEdge(aLeavingEdge);
        if (aTargetNode.enteringEdges().count() == 0L) {
            this.sourceNodes.add(aTargetNode);
        }
    }

    private Set<Node> calculateSourceNodes() {
        Set<Node> aSourceNodeSet = this.graph.nodes().filter(aNode -> aNode.getInDegree() == 0).collect(Collectors.toSet());
        if (aSourceNodeSet.isEmpty()) {
            this.throwException();
        }
        return aSourceNodeSet;
    }

    private void throwException() {
        throw new IllegalStateException("graph is no DAG");
    }

    public List<Node> getSortedNodes() {
        return this.sortedNodes;
    }

    @Result
    public String defaultResult() {
        return this.getSortedNodes().toString();
    }
}

