/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.HashMap;
import java.util.Stack;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public class TarjanStronglyConnectedComponents
implements Algorithm {
    protected HashMap<Node, NodeData> data = new HashMap();
    protected int index;
    protected Stack<Node> S = new Stack();
    protected IndexGenerator sccIndex = new IntegerIndexGenerator();
    protected String sccAttribute = "scc";
    protected Graph graph;

    @Override
    public void init(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void compute() {
        this.data.clear();
        this.index = 0;
        this.S.clear();
        this.graph.nodes().filter(v -> !this.data.containsKey(v)).forEach(v -> this.strongConnect((Node)v));
    }

    @Parameter
    public void setIndexGenerator(IndexGenerator gen) {
        if (gen == null) {
            throw new NullPointerException();
        }
        this.sccIndex = gen;
    }

    @Parameter
    public void setSCCIndexAttribute(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.sccAttribute = key;
    }

    public String getSCCIndexAttribute() {
        return this.sccAttribute;
    }

    @Result
    public String defaultMessage() {
        return "Result stored in \"" + this.sccAttribute + "\" attribute";
    }

    protected void strongConnect(Node v) {
        NodeData nd = new NodeData();
        this.data.put(v, nd);
        nd.index = this.index;
        nd.lowlink = this.index++;
        this.S.push(v);
        v.leavingEdges().forEach(vw -> {
            Node w = vw.getOpposite(v);
            if (!this.data.containsKey(w)) {
                this.strongConnect(w);
                nd.lowlink = Math.min(nd.lowlink, this.data.get((Object)w).lowlink);
            } else if (this.S.contains(w)) {
                nd.lowlink = Math.min(nd.lowlink, this.data.get((Object)w).index);
            }
        });
        if (nd.index == nd.lowlink) {
            Node w;
            Object currentSCCIndex = this.sccIndex.nextIndex();
            do {
                w = this.S.pop();
                w.setAttribute(this.sccAttribute, currentSCCIndex);
            } while (w != v);
        }
    }

    public static class IntegerIndexGenerator
    implements IndexGenerator {
        private int index = 0;

        @Override
        public Object nextIndex() {
            return this.index++;
        }
    }

    public static interface IndexGenerator {
        public Object nextIndex();
    }

    protected static class NodeData {
        int index;
        int lowlink;

        protected NodeData() {
        }
    }
}

