/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.ElementSink;

public class PageRank
implements DynamicAlgorithm,
ElementSink {
    public static final double DEFAULT_DAMPING_FACTOR = 0.85;
    public static final double DEFAULT_PRECISION = 1.0E-5;
    public static final String DEFAULT_RANK_ATTRIBUTE = "PageRank";
    protected double dampingFactor;
    protected double precision;
    protected String rankAttribute;
    protected Graph graph;
    protected boolean upToDate;
    protected double normDiff;
    protected List<Double> newRanks;
    protected int iterationCount;
    protected boolean verbose;

    public PageRank() {
        this(0.85, 1.0E-5, DEFAULT_RANK_ATTRIBUTE);
    }

    public PageRank(double dampingFactor, double precision, String rankAttribute) {
        this.setDampingFactor(dampingFactor);
        this.setPrecision(precision);
        this.setRankAttribute(rankAttribute);
        this.verbose = false;
    }

    public double getDampingFactor() {
        return this.dampingFactor;
    }

    @Parameter
    public void setDampingFactor(double dampingFactor) throws IllegalArgumentException {
        if (dampingFactor < 0.01 || dampingFactor > 0.99) {
            throw new IllegalArgumentException("The damping factor must be between 0.01 and 0.99");
        }
        this.dampingFactor = dampingFactor;
        this.upToDate = false;
    }

    public double getPrecision() {
        return this.precision;
    }

    @Parameter
    public void setPrecision(double precision) throws IllegalArgumentException {
        if (precision < 1.0E-7) {
            throw new IllegalArgumentException("Precision is too small");
        }
        this.precision = precision;
        this.upToDate = false;
    }

    public String getRankAttribute() {
        return this.rankAttribute;
    }

    @Parameter
    public void setRankAttribute(String rankAttribute) throws IllegalStateException {
        if (this.graph != null) {
            throw new IllegalStateException("this method can be called only before init");
        }
        this.rankAttribute = rankAttribute;
    }

    @Parameter
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void init(Graph graph) {
        this.graph = graph;
        graph.addElementSink(this);
        double initialRank = 1.0 / (double)graph.getNodeCount();
        graph.nodes().forEach(node -> node.setAttribute(this.rankAttribute, initialRank));
        this.newRanks = new ArrayList<Double>(graph.getNodeCount());
        this.upToDate = false;
        this.iterationCount = 0;
    }

    @Override
    public void compute() {
        if (this.upToDate) {
            return;
        }
        do {
            this.iteration();
            if (!this.verbose) continue;
            System.err.printf("%6d%16.8f%n", this.iterationCount, this.normDiff);
        } while (this.normDiff > this.precision);
        this.upToDate = true;
    }

    @Override
    public void terminate() {
        this.graph.removeElementSink(this);
        this.newRanks.clear();
        this.newRanks = null;
        this.graph = null;
    }

    @Result
    public String defaultResult() {
        this.graph.nodes().forEach(node -> {
            double rank = this.getRank((Node)node);
            node.setAttribute("ui.size", 5.0 + Math.sqrt((double)this.graph.getNodeCount() * rank * 20.0));
            node.setAttribute("ui.label", String.format("%.2f%%", rank * 100.0));
        });
        return "ui.size and ui.label changed";
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.graph.getNode(nodeId).setAttribute(this.rankAttribute, this.graph.getNodeCount() == 1 ? 1.0 : 0.0);
        this.upToDate = false;
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        double part = this.graph.getNode(nodeId).getNumber(this.rankAttribute) / (double)(this.graph.getNodeCount() - 1);
        this.graph.nodes().filter(node -> !node.getId().equals(nodeId)).forEach(node -> node.setAttribute(this.rankAttribute, node.getNumber(this.rankAttribute) + part));
        this.upToDate = false;
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.upToDate = false;
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.upToDate = false;
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.upToDate = true;
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
    }

    protected void iteration() {
        Node node;
        int i;
        double dampingTerm = (1.0 - this.dampingFactor) / (double)this.graph.getNodeCount();
        this.newRanks.clear();
        double danglingRank = 0.0;
        for (i = 0; i < this.graph.getNodeCount(); ++i) {
            node = this.graph.getNode(i);
            double sum = 0.0;
            for (int j = 0; j < node.getInDegree(); ++j) {
                Node other = node.getEnteringEdge(j).getOpposite(node);
                sum += other.getNumber(this.rankAttribute) / (double)other.getOutDegree();
            }
            this.newRanks.add(dampingTerm + this.dampingFactor * sum);
            if (node.getOutDegree() != 0) continue;
            danglingRank += node.getNumber(this.rankAttribute);
        }
        danglingRank *= this.dampingFactor / (double)this.graph.getNodeCount();
        this.normDiff = 0.0;
        for (i = 0; i < this.graph.getNodeCount(); ++i) {
            node = this.graph.getNode(i);
            double currentRank = node.getNumber(this.rankAttribute);
            double newRank = this.newRanks.get(i) + danglingRank;
            this.normDiff += Math.abs(newRank - currentRank);
            node.setAttribute(this.rankAttribute, newRank);
        }
        ++this.iterationCount;
    }

    public double getRank(Node node) {
        this.compute();
        return node.getNumber(this.rankAttribute);
    }

    public int getIterationCount() {
        return this.iterationCount;
    }
}

