/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.TopologicalSortDFS;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;

public class LongestPath
implements Algorithm {
    public static final String DEFAULT_WEIGHT_ATTRIBUTE = "weight";
    private Graph graph;
    private Map<Node, Double> distanceMap;
    private List<Node> longestPath;
    private Map.Entry<Node, Double> longestPathNode;
    private boolean weighted = true;
    private String weightAttribute;

    @Override
    public void init(Graph theGraph) {
        this.graph = theGraph;
        this.distanceMap = new HashMap<Node, Double>();
        this.longestPath = new ArrayList<Node>();
    }

    @Override
    public void compute() {
        this.initializeAlgorithm();
        TopologicalSortDFS aTopoSortAlgorithm = new TopologicalSortDFS();
        aTopoSortAlgorithm.init(this.graph);
        aTopoSortAlgorithm.compute();
        this.fillDistanceMap(aTopoSortAlgorithm.getSortedNodes());
        this.longestPathNode = this.distanceMap.entrySet().stream().max(Map.Entry.comparingByValue()).orElse(null);
        if (this.longestPathNode == null) {
            throw new IllegalStateException("No max node found!");
        }
        this.longestPath.add(this.longestPathNode.getKey());
        this.getMaxNeighbor(this.longestPathNode.getKey());
        Collections.reverse(this.longestPath);
    }

    private void fillDistanceMap(List<Node> theSortedArray) {
        for (Node aNode : theSortedArray) {
            aNode.enteringEdges().forEach(anEdge -> {
                Node aSourceNode = anEdge.getSourceNode();
                Node aTargetNode = anEdge.getTargetNode();
                double aWeight = this.weighted ? anEdge.getNumber(this.getWeightAttribute()) : 1.0;
                Double aMaxDistance = Math.max(this.distanceMap.get(aTargetNode), this.distanceMap.get(aSourceNode) + aWeight);
                this.distanceMap.put(aTargetNode, aMaxDistance);
            });
        }
    }

    private void getMaxNeighbor(Node theNode) {
        Optional<Edge> optionalEdge = theNode.enteringEdges().max(Comparator.comparingDouble(anEdge -> this.distanceMap.get(anEdge.getSourceNode())));
        optionalEdge.ifPresent(edge -> {
            this.longestPath.add(edge.getSourceNode());
            this.getMaxNeighbor(edge.getSourceNode());
        });
    }

    private void initializeAlgorithm() {
        this.graph.nodes().forEach(aNode -> {
            aNode.edges().forEach(anEdge -> {
                double aWeight = anEdge.getNumber(this.getWeightAttribute());
                if (Double.isNaN(aWeight)) {
                    this.weighted = false;
                }
            });
            this.distanceMap.put((Node)aNode, 0.0);
        });
    }

    public List<Node> getLongestPathList() {
        return this.longestPath;
    }

    public Path getLongestPath() {
        Path path = new Path();
        for (int i = 0; i < this.longestPath.size() - 1; ++i) {
            Node aSourceNode = this.longestPath.get(i);
            Node aTargetNode = this.longestPath.get(i + 1);
            Optional<Edge> anEdge = this.graph.edges().filter(aNode -> aNode.getSourceNode().equals(aSourceNode)).filter(aNode -> aNode.getTargetNode().equals(aTargetNode)).findAny();
            anEdge.ifPresent(edge -> path.add(aSourceNode, (Edge)edge));
        }
        return path;
    }

    @Result
    public String defaultResult() {
        return this.getLongestPath().toString();
    }

    public Double getLongestPathValue() {
        return this.longestPathNode.getValue();
    }

    public String getWeightAttribute() {
        return this.weightAttribute == null ? DEFAULT_WEIGHT_ATTRIBUTE : this.weightAttribute;
    }

    @Parameter
    public void setWeightAttribute(String weightAttribute) {
        this.weightAttribute = weightAttribute;
    }
}

